=begin
= rd2html-opt.rb
sub-OptionParser for rd2html-lib.rb.
NOTE: this structure of sub-OptionParser is very experimental.
=end
require "optparse"

q = ARGV.options

q.on_tail("rd2html-lib options:")

q.on_tail("--with-css=FILE",
	  String,
	  "use FILE as CSS of output HTML") do |i|
  $Visitor.css = i
end

q.on_tail("--html-charset=LANG",
	  String,
	  "indicate LANG as charset(char encoding)") do |i|
  $Visitor.charset = i
end
  
q.on_tail("--html-title=TITLE",
	  String,
	  "content of TITLE element of HTML") do |i|
  $Visitor.title = i
end

q.on_tail("--html-link-rel=REL",
	  String,
	  "add forward LINK element.(\"<rel>:<href>\")") do |i|
  if /(\w+):(.+)/ =~ i
    $Visitor.html_link_rel[$1] = $2
  else
    # warning
  end
end

q.on_tail("--html-link-rev=REV",
	  String,
	  "add reverse LINK element.(\"<rev>:<href>\")") do |i|
  if /(\w+):(.+)/ =~ i
    $Visitor.html_link_rev[$1] = $2
  else
    # warning
  end
end



