
require 'racc/parser'
require "rd/rdinlineparser.tab.rb"

=begin
= rdblockparser.ry
== What is rdblockparser.ry
RDtool parse RD with two kinds of parser. One is for Block level parsing,
and another is for Inline level parsing. rdblockparser.ry is Racc syntax
definition for Block level parser.

== Block level and Inline level
In Block level, RD's syntax widely uses indent. So RDtool devides parsing
process into two levels to simplify syntax and lexical analizing. 
Class RDBlockParser in rdblockparser.ry is to do this Block level parsing
process, and Class RDInlineParser in rdinlineparser.ry do Inline level
one. A instance of RDBlockParser has a instance of RDInlineParser.
RDBlockParser parse RD with help of RDInlineParser. 

== Block level Parsing
Please read BNF of syntax definition in rdblockparser.ry.

== Block level lexical analizing
Now Racc needs only ((*one*)) method, (({next_token})) for lexical analyzing.
So, (({tokenize})) is into (({next_token})), and (({@rylval})) has desappeared.

Lexer regards Each line as token, (({STRINGLINE})), (({WHITELINE})),
(({BLANKLINE})) or (({HEADLINE})). But lexer also see how indent line
is and if line starts with some special character, for example 
(({LISTMARK}))s.

Lexer manages indent with a stack, "(({@indent_stack}))". 
(({@indent_stack})) have the current state of indent. So lexer know
current baseline, that is as deep as 
(({currentIndent = @indent_stack.join("")})). When indent of current line
is deeper than baseline, lexer push diff of indent of current line
and baseline into (({@indent_stack})) and return INDENT to parser.
And when indent of current line is sharrower than baseline, lexer
do (({@index_stack.pop})) and return DEDENT.
=end
=begin
== script info.
 parser for RD Blocks.
 $Id: rdblockparser.tab.rb,v 1.1 2001/01/23 22:10:48 dave Exp $

== changes
:0.6.2
  * RD Include bug fix. thanks. > Arai
:0.6.1
  * textblock rule become neat. (with using operator priority rule)
  * bug about List parse is fixed.
  * come to cut whitelines at the end of Verbatim.
:0.6.0
  * parser tuning up. thanks for advice. > Aoki
  * MethodList. thanks. > Arai
  * error message. thanks. > Aoki
  * subparser. RDTree#preprocess -> RDParser#next_token
  * R/S conflicts are resolved by Aoki. thanks! > Aoki
:0.5.4
  * BLANKLINE |--> WHITELINE
:0.5.3
  * change for racc-0.10.0
  * empty description of DescListItem
:0.5.2
  * into RD module.
  * bug fix.
:0.5.0
  * added.
=end

module RD
class RDParser < Racc::Parser
def initialize
  @inline_parser = RDInlineParser.new(self)
end

def parse(src, tree)
  @src = src
#  @src.unshift("\n")
#  @src.push("\n")
  @src.push(false)
  # RDtree
  @tree = tree
  
  # @i: index(line no.) of src
  @i = 0
  # stack for current indentation
  @indent_stack = []
  # how indented.
  @current_indent = @indent_stack.join("")
  # RDParser for tmp src
  @subparser = nil
  # which part is in now
  @in_part = nil
  @part_content = []
  @tmpfile_num = 0
  
  # swap_line status var.(for error message)
  @swaped_line = ""
  @is_swaped

  @yydebug = true
  do_parse
end

def next_token
  @is_swaped = false
  # preprocessing
  # if it is not in RD part
  # => method
  while @in_part != "rd"
    line = @src[@i]
    @i += 1
    
    case line
    # src end
    when false
      return [false, false]
    # RD part begin
    when /^=begin\s*(?:\bRD\b.*)?\s*$/
      if @in_part # if in non-RD part
	@part_content.push(line)
      else
	@in_part = "rd"
	return [:WHITELINE, "=begin\n"] # <= for textblockand
      end
    # non-RD part begin
    when /^=begin\s+(\w+)/
      part = $1
      if @in_part # if in non-RD part
	@part_content.push(line)
      else
	@in_part = part if @tree.filter[part] # if filter exists
#	p "BEGIN_PART: #{@in_part}" # DEBUG
      end
    # non-RD part end
    when /^=end/
      if @in_part # if in non-RD part
#	p "END_PART: #{@in_part}" # DEBUG
	# make Part-in object
	part = RD::Part.new(@part_content.join(""), @tree, "r")
	@part_content.clear
	# call filter, part_out is output(Part object)
	part_out = @tree.filter[@in_part].call(part)
	
	if @tree.filter[@in_part].mode == :rd # if output is RD formated
	  subtree = parse_subtree(part_out.to_a)
	else # if output is target formated
	  basename = "rdtmp.#{$$}.#{@tmpfile_num}"
	  @tmpfile_num += 1
	  tmpfile = open(@tree.tmp_dir + "/" + basename + ".#{@in_part}", "w")
	  tmpfile.print(part_out)
	  tmpfile.close
	  subtree = parse_subtree(["=begin\n", "<<< #{basename}\n", "=end\n"])
	end
	@in_part = nil
	return [:SUBTREE, subtree]
      end
    else
      if @in_part # if in non-RD part
	@part_content.push(line)
      end
    end
  end

  @current_indent = @indent_stack.join("")
  line = @src[@i]
  case line
  when false
    if_current_indent_equal("") do
      next_line
      [false, false]
    end
  when /^=end/
    if_current_indent_equal("") do
      @in_part = nil
      next_line
      [:WHITELINE, "=end"] # MUST CHANGE
    end
  when /^\s*$/
    next_line
    return [:WHITELINE, ':WHITELINE']
  when /^(=+|\++)\s*/
    rest = $'                    # '
    mark = $1
    if_current_indent_equal("") do
      swap_line(rest)
      return [:HEADLINEMARK, Headline.mark_to_level(mark)]
    end
  when /^<<<\s*(\S+)/
    file = $1
    if_current_indent_equal("") do
      suffix = file[-3 .. -1] 
      if suffix == ".rd" or suffix == ".rb"
	subtree = parse_subtree(get_included(file))
	next_line
	[:SUBTREE, subtree]
      else
	swap_line(file.concat("\n"))
	[:INCLUDEMARK, ':INCLUDEMARK']
      end
    end
  when /^(\s*)\*/
    rest = $'                   # '
    if_current_indent_equal($1) do
      if @in_verbatim
	next_line
	[:STRINGLINE, line]
      else
	swap_line(@current_indent + "\s" + rest)
	[:ITEMLISTMARK, "*"]
      end
    end
  when /^(\s*)(\(\d+\))/
    mark = $2
    rest = $'                     # '
    if_current_indent_equal($1) do
      if @in_verbatim
	next_line
	[:STRINGLINE, line]
      else
	swap_line(@current_indent + "\s" * mark.size + rest)
	[:ENUMLISTMARK, mark]
      end
    end
  when /^(\s*):/
    rest = $'                    # '
    if_current_indent_equal($1) do
      if @in_verbatim
	next_line
	[:STRINGLINE, line]
      else
	swap_line(@current_indent + "\s" + rest)
	[:DESCLISTMARK, ':']
      end
    end
  when /^(\s*)---(?=[^-])/
    rest = $'                   # '
    if_current_indent_equal($1) do
      if @in_verbatim
	next_line
	[:STRINGLINE, line]
      else
	swap_line(@current_indent + "\s\s\s" + rest)
	[:METHODLISTMARK, '---']
      end
    end
  when /^(\s*)/
    if_current_indent_equal($1) do
      next_line
      [:STRINGLINE, line]
    end
  else
    raise "[BUG] parsing error may occured."
  end
end

=begin private
if_current_indent_equal:
if @current_indent == indent
   yield block
otherwise
   process indentation
=end
def if_current_indent_equal(indent)
  if @current_indent == indent
    yield
  elsif indent.index(@current_indent) == 0
    @indent_stack.push(indent[@current_indent.size .. -1])
    [:INDENT, ":INDENT"]
  else
    @indent_stack.pop
    [:DEDENT, ":DEDENT"]
  end
end
private :if_current_indent_equal

def next_line
    @i += 1
end
private :next_line

def swap_line(line)
  @swaped_line = @src[@i]
  @is_swaped = true
  @src[@i] = line
end
private :swap_line

def cut_off(src)
  ret = []
  whiteline_buf = []
  line = src.shift
  /^\s*/ =~ line
  indent = Regexp.quote($&)
  ret.push($')                 # '
  while line = src.shift
    if /^(\s*)$/ =~ line
      whiteline_buf.push(line)
    elsif /^#{indent}/ =~ line
      unless whiteline_buf.empty?
	ret.concat(whiteline_buf)
	whiteline_buf.clear
      end
      ret.push($')            # '
    else
      raise "[BUG]: probably Parser Error while cutting off.\n"
    end
  end
  ret
end
private :cut_off

def on_error( et, ev, _values )
  if @is_swaped
    line = @swaped_line
  else
    line = @src[@i]
  end
  
  raise ParseError, <<Msg

RD syntax error: line #{@i+1}:
#{line}

[BUG]: sorry, this seems to be RDtool's  bug.
et: #{et}
ev: #{ev}

Msg
end # '

def line_index
  @i
end

def parse_subtree(src)
  @subparser = RD::RDParser.new() unless @subparser
  
  @subparser.parse(src, @tree)
end
private :parse_subtree

def get_included(file)
  included = ""
  @tree.include_path.each do |dir|
    file_name = dir + "/" + file
    if test(?e, file_name)
      included = IO.readlines(file_name)
      break
    end
  end
  included
end
private :get_included

##### racc 1.0.0 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 1, 15, :_reduce_1,
 2, 16, :_reduce_2,
 1, 16, :_reduce_none,
 1, 17, :_reduce_4,
 1, 17, :_reduce_5,
 1, 17, :_reduce_none,
 1, 17, :_reduce_7,
 1, 17, :_reduce_8,
 1, 17, :_reduce_9,
 1, 17, :_reduce_10,
 2, 21, :_reduce_11,
 2, 22, :_reduce_12,
 1, 18, :_reduce_13,
 2, 23, :_reduce_14,
 1, 23, :_reduce_15,
 3, 19, :_reduce_16,
 2, 24, :_reduce_17,
 4, 24, :_reduce_18,
 2, 24, :_reduce_19,
 1, 24, :_reduce_20,
 1, 25, :_reduce_none,
 1, 25, :_reduce_none,
 1, 25, :_reduce_none,
 1, 25, :_reduce_none,
 1, 20, :_reduce_none,
 3, 20, :_reduce_26,
 4, 20, :_reduce_27,
 2, 30, :_reduce_28,
 1, 30, :_reduce_29,
 1, 26, :_reduce_30,
 2, 31, :_reduce_31,
 1, 31, :_reduce_32,
 4, 32, :_reduce_33,
 1, 27, :_reduce_34,
 2, 34, :_reduce_35,
 1, 34, :_reduce_36,
 4, 35, :_reduce_37,
 1, 28, :_reduce_38,
 2, 36, :_reduce_39,
 1, 36, :_reduce_40,
 5, 37, :_reduce_41,
 1, 29, :_reduce_42,
 2, 39, :_reduce_43,
 1, 39, :_reduce_44,
 5, 40, :_reduce_45,
 1, 38, :_reduce_none,
 3, 38, :_reduce_47,
 1, 38, :_reduce_48,
 0, 38, :_reduce_49,
 2, 33, :_reduce_50,
 1, 33, :_reduce_51,
 2, 41, :_reduce_52,
 1, 41, :_reduce_none,
 1, 42, :_reduce_54,
 1, 42, :_reduce_55,
 1, 42, :_reduce_none,
 1, 42, :_reduce_57 ]

racc_reduce_n = 58

racc_shift_n = 85

racc_action_table = [
    10,     7,     4,     1,    20,    69,    63,     7,    50,    19,
    84,    10,     7,     4,     1,    10,     7,     4,     1,    44,
    58,    57,    10,     7,     4,     1,    20,    69,    51,    52,
    38,    19,    10,     7,     4,     1,    20,    69,    20,     4,
    47,    19,    10,     7,     4,     1,    20,    69,    48,    46,
    40,    19,    10,     7,     4,     1,    20,    25,    24,    23,
    22,    19,    10,     7,     4,     1,    20,    25,    24,    23,
    22,    19,    61,    59,    61,    59,    36,    60,    62,    60,
    83,    20,    64,    20,    64,    75,    65,    76,    65,    10,
     7,     4,     1,    77,    44,    44,     1,    80,    81,    34,
    10,    20 ]

racc_action_check = [
    79,    79,    79,    79,    79,    79,    50,     9,    33,    79,
    79,    43,    43,    43,    43,    19,    19,    19,    19,    19,
    43,    43,    53,    53,    53,    53,    53,    53,    34,    36,
     7,    53,    65,    65,    65,    65,    65,    65,    40,     6,
    22,    65,    74,    74,    74,    74,    74,    74,    23,    21,
    10,    74,    32,    32,    32,    32,    32,    32,    32,    32,
    32,    32,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    45,    45,    78,    78,     4,    45,    45,    78,
    78,    52,    52,    51,    51,    54,    52,    55,    51,    14,
    14,    14,    14,    56,    58,    60,     3,    67,    68,     1,
    12,    38 ]

racc_action_default = [
   -58,   -58,   -44,   -42,   -58,   -40,   -38,   -58,   -36,   -34,
   -58,   -32,   -30,   -29,   -25,   -24,   -23,   -22,   -21,   -58,
   -15,   -13,   -58,   -58,   -10,    -9,    -8,    -7,    -6,    -5,
    -4,    -3,    -1,   -58,   -58,   -43,   -58,   -39,   -58,   -35,
   -58,   -31,   -28,   -58,   -20,   -58,   -14,   -12,   -11,    -2,
   -58,   -49,   -49,   -51,   -58,   -58,   -58,   -26,   -58,   -19,
   -58,   -17,   -16,    85,   -48,   -58,   -46,   -58,   -58,   -57,
   -56,   -55,   -54,   -53,   -50,   -37,   -33,   -27,   -58,   -58,
   -45,   -41,   -52,   -18,   -47 ]

racc_action_pointer = [
    59,    87,   nil,    90,    64,   nil,    34,    18,   nil,     3,
    38,   nil,    97,   nil,    86,   nil,   nil,   nil,   nil,    12,
   nil,    42,    33,    41,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    49,     8,    21,   nil,    22,   nil,    94,   nil,
    31,   nil,   nil,     8,   nil,    65,   nil,   nil,   nil,   nil,
     6,    76,    74,    19,    72,    74,    80,   nil,    87,   nil,
    88,   nil,   nil,   nil,   nil,    29,   nil,    84,    85,   nil,
   nil,   nil,   nil,   nil,    39,   nil,   nil,   nil,    67,    -3,
   nil,   nil,   nil,   nil,   nil ]

racc_goto_table = [
    30,    29,    31,    28,    74,    82,    54,    42,    55,    43,
    82,    67,    68,    41,    39,    37,    79,    78,    35,    32,
    33,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    30,    29,    49,    28,    42,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    56,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,    72,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,    72,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,    72,   nil,   nil,   nil,   nil,    72 ]

racc_goto_check = [
     4,     5,     3,     6,    27,    28,    19,    11,    19,    16,
    28,    24,    24,    18,    21,    23,    27,    10,    26,     2,
     1,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,     4,     5,     3,     6,    11,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,     5,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,     4,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,     4,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,     4,   nil,   nil,   nil,   nil,     4 ]

racc_goto_pointer = [
   nil,    20,    19,     2,     0,     1,     3,   nil,   nil,   nil,
   -43,    -7,   nil,   nil,   nil,   nil,   -10,   nil,     1,   -32,
   nil,     5,   nil,     9,   -40,   nil,    15,   -49,   -69 ]

racc_goto_default = [
   nil,   nil,   nil,   nil,    53,    71,    70,    27,    26,    21,
    45,    13,    18,    17,    16,    15,    14,    12,    11,    66,
     9,     8,     6,     5,   nil,     3,     2,   nil,    73 ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :DUMMY => 2,
 :ITEMLISTMARK => 3,
 :ENUMLISTMARK => 4,
 :DESCLISTMARK => 5,
 :METHODLISTMARK => 6,
 :STRINGLINE => 7,
 :WHITELINE => 8,
 :SUBTREE => 9,
 :HEADLINEMARK => 10,
 :INCLUDEMARK => 11,
 :INDENT => 12,
 :DEDENT => 13 }

racc_nt_base = 14

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n ]

Racc_debug_parser = false

##### racc system variables end #####


 # reduce 0 omitted

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 9 )
  def _reduce_1( val, _values, result )
 result = DocumentElement.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 11 )
  def _reduce_2( val, _values, result )
 result.concat(val[1])
   result
  end
.,.,

 # reduce 3 omitted

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 14 )
  def _reduce_4( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 15 )
  def _reduce_5( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 6 omitted

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 17 )
  def _reduce_7( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 18 )
  def _reduce_8( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 20 )
  def _reduce_9( val, _values, result )
 result = []
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 21 )
  def _reduce_10( val, _values, result )
 result = val[0].blocks
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 25 )
  def _reduce_11( val, _values, result )
			title = @inline_parser.parse(val[1])
#			title = val[1].strip
			result = Headline.new(val[0], title)
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 30 )
  def _reduce_12( val, _values, result )
			fileName = val[1].strip
			result = Include.new(fileName)
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 40 )
  def _reduce_13( val, _values, result )
			# val[0] is Array of String
			content = cut_off(val[0]).join("")
			content = @inline_parser.parse(content)
			result = TextBlock.new(content)
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 46 )
  def _reduce_14( val, _values, result )
				   result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 47 )
  def _reduce_15( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 51 )
  def _reduce_16( val, _values, result )
			# val[1] is Array of String
			content = cut_off(val[1])
			result = Verbatim.new(content)
			# imform to lexer.
			@in_verbatim = false
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 58 )
  def _reduce_17( val, _values, result )
					result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 60 )
  def _reduce_18( val, _values, result )
 					result.concat(val[2])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 62 )
  def _reduce_19( val, _values, result )
					result.push("\n")
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 63 )
  def _reduce_20( val, _values, result )
 result = val
					# imform to lexer.
					@in_verbatim = true
   result
  end
.,.,

 # reduce 21 omitted

 # reduce 22 omitted

 # reduce 23 omitted

 # reduce 24 omitted

 # reduce 25 omitted

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 74 )
  def _reduce_26( val, _values, result )
 result = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 75 )
  def _reduce_27( val, _values, result )
 result = val[1].push(val[2])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 78 )
  def _reduce_28( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 79 )
  def _reduce_29( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 84 )
  def _reduce_30( val, _values, result )
 result = ItemList.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 87 )
  def _reduce_31( val, _values, result )
			result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 88 )
  def _reduce_32( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 91 )
  def _reduce_33( val, _values, result )
			result = ItemListItem.new(val[2])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 97 )
  def _reduce_34( val, _values, result )
 result = EnumList.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 100 )
  def _reduce_35( val, _values, result )
			result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 101 )
  def _reduce_36( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 104 )
  def _reduce_37( val, _values, result )
			result = EnumListItem.new(val[2])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 109 )
  def _reduce_38( val, _values, result )
 result = DescList.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 112 )
  def _reduce_39( val, _values, result )
			result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 113 )
  def _reduce_40( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 117 )
  def _reduce_41( val, _values, result )
			term = @inline_parser.parse(val[2])
#			term = val[2].strip
			result = DescListItem.new(term, val[3])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 124 )
  def _reduce_42( val, _values, result )
 result = MethodList.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 127 )
  def _reduce_43( val, _values, result )
			result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 128 )
  def _reduce_44( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 132 )
  def _reduce_45( val, _values, result )
#			term = @inline_parser.parse(val[2])
			term = val[2].strip
			result = MethodListItem.new(term, val[3])
   result
  end
.,.,

 # reduce 46 omitted

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 139 )
  def _reduce_47( val, _values, result )
 result = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 140 )
  def _reduce_48( val, _values, result )
 result = []
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 141 )
  def _reduce_49( val, _values, result )
 result = []
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 143 )
  def _reduce_50( val, _values, result )
 result = [val[0]].concat(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 144 )
  def _reduce_51( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 146 )
  def _reduce_52( val, _values, result )
 result.concat(val[1])
   result
  end
.,.,

 # reduce 53 omitted

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 149 )
  def _reduce_54( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 150 )
  def _reduce_55( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 56 omitted

 module_eval( <<'.,.,', 'rd/rdblockparser.ry', 152 )
  def _reduce_57( val, _values, result )
 result= []
   result
  end
.,.,

end
end # end of module RD 
