
require 'racc/parser'
=begin
= rdinlineparser.ry
== What is rdinlineparser.ry
rdinlineparser.ry is Racc syntax definition file for Inline level
parsing. rdinlineparser.tab.rb is required by rdblockparser.tab.rb,
and RDInlineParser is used RDBlockParser.

Please read rdblockparser.ry for more details.

== Inline level parsing
Inline level parsing is very simple. You can easily understand it
when you read BNF in rdinlineparser.ry.

Now RDInlineParser can parse only regular RD. "regular" means Inline
brackets are exactly nested. For example,
  This is regular
  ((- Footnote and ((*Em*)). -))
  And they are ilregular
  ((- Footnote and ((*Emphasis -)) . *))
  ((- Not closed pair of bracket.
When RDInlineParser meats such a ilregular RD, RDInlineParser raises
a Exception...
== Inline level lexical analizing
In Inline level, lexer do all lexical analizing before parsing. Each
tokens are pushed into (({@token_queue})) and each values into 
(({@value_queue})).
=end
=begin
== script info.
 parser for RD Inline.
 $Id: rdinlineparser.tab.rb,v 1.1 2001/01/23 22:10:48 dave Exp $

== changes
:0.6.3
  * Ruby 1.5 makes (({p})) option of Regexp is obsolute and (({m})) option is
    alternative one. A workaround for this change is written.
:0.6.2
  * Reference filename bug fix.
:0.6.1
  * (({DUMMY})) -> (({EX_LOW}))
:0.6.0
  * error message. thanks. > Aoki
  * all Reference feature are covered.
  * parser come to use strscan.so.
  * logic are changed. lexer becomes more simple.
:0.5.4
  * bug about Verb is fixed.
:0.5.3
  * change for racc-0.10.0
:0.5.2
  * into RD module.
  * bug fix.
:0.5.0
  * added.
=end

require "strscan"

module RD
class RDInlineParser < Racc::Parser
EM_OPEN = '((*'
EM_OPEN_RE = /#{Regexp.quote(EM_OPEN)}/
EM_CLOSE = '*))'
EM_CLOSE_RE = /#{Regexp.quote(EM_CLOSE)}/
CODE_OPEN = '(({'
CODE_OPEN_RE = /#{Regexp.quote(CODE_OPEN)}/
CODE_CLOSE = '}))'
CODE_CLOSE_RE = /#{Regexp.quote(CODE_CLOSE)}/
VAR_OPEN = '((|'
VAR_OPEN_RE = /#{Regexp.quote(VAR_OPEN)}/
VAR_CLOSE = '|))'
VAR_CLOSE_RE = /#{Regexp.quote(VAR_CLOSE)}/
KBD_OPEN = '((%'
KBD_OPEN_RE = /#{Regexp.quote(KBD_OPEN)}/
KBD_CLOSE = '%))'
KBD_CLOSE_RE = /#{Regexp.quote(KBD_CLOSE)}/
INDEX_OPEN = '((:'
INDEX_OPEN_RE = /#{Regexp.quote(INDEX_OPEN)}/
INDEX_CLOSE = ':))'
INDEX_CLOSE_RE = /#{Regexp.quote(INDEX_CLOSE)}/
REF_OPEN = '((<'
REF_OPEN_RE = /#{Regexp.quote(REF_OPEN)}/
REF_CLOSE = '>))'
REF_CLOSE_RE = /#{Regexp.quote(REF_CLOSE)}/
FOOTNOTE_OPEN = '((-'
FOOTNOTE_OPEN_RE = /#{Regexp.quote(FOOTNOTE_OPEN)}/
FOOTNOTE_CLOSE = '-))'
FOOTNOTE_CLOSE_RE = /#{Regexp.quote(FOOTNOTE_CLOSE)}/
VERB_OPEN = "(('"
VERB_OPEN_RE = /#{Regexp.quote(VERB_OPEN)}/
VERB_CLOSE = "'))"
VERB_CLOSE_RE = /#{Regexp.quote(VERB_CLOSE)}/

BAR = "|"
BAR_RE = /#{Regexp.quote(BAR)}/
QUOTE = '"'
QUOTE_RE = /#{Regexp.quote(QUOTE)}/
SLASH = "/"
SLASH_RE = /#{Regexp.quote(SLASH)}/
BACK_SLASH = "\\"
BACK_SLASH_RE = /#{Regexp.quote(BACK_SLASH)}/
URL = "URL:"
URL_RE = /#{Regexp.quote(URL)}/

# Workaround for Regexp option change of Ruby 1.5.x
other_re_mode = Regexp::EXTENDED
if RUBY_VERSION > "1.5"
  other_re_mode |= Regexp::MULTILINE
else
  other_re_mode |= Regexp::POSIXLINE
end

OTHER_RE = Regexp.new(
		  ".+?(?=#{Regexp.quote(EM_OPEN)}|#{Regexp.quote(EM_CLOSE)}|
                  #{Regexp.quote(CODE_OPEN)}|#{Regexp.quote(CODE_CLOSE)}|
                  #{Regexp.quote(VAR_OPEN)}|#{Regexp.quote(VAR_CLOSE)}|
                  #{Regexp.quote(KBD_OPEN)}|#{Regexp.quote(KBD_CLOSE)}|
                  #{Regexp.quote(INDEX_OPEN)}|#{Regexp.quote(INDEX_CLOSE)}|
                  #{Regexp.quote(REF_OPEN)}|#{Regexp.quote(REF_CLOSE)}|
                #{Regexp.quote(FOOTNOTE_OPEN)}|#{Regexp.quote(FOOTNOTE_CLOSE)}|
                  #{Regexp.quote(VERB_OPEN)}|#{Regexp.quote(VERB_CLOSE)}|
                  #{Regexp.quote(BAR)}|
                  #{Regexp.quote(QUOTE)}|
                  #{Regexp.quote(SLASH)}|
                  #{Regexp.quote(BACK_SLASH)}|
                  #{Regexp.quote(URL)})", other_re_mode)

def initialize(bp)
  @blockp = bp
end

def parse(src)
  @src = StringScanner.new(src)
  @pre = ""
  @yydebug = true
  do_parse
end

def next_token
  return [false, false] if @src.empty?
#  p @src.rest if @yydebug
  if ret = @src.scan(EM_OPEN_RE)
    @pre << ret
    [:EM_OPEN, ret]
  elsif ret = @src.scan(EM_CLOSE_RE)
    @pre << ret
    [:EM_CLOSE, ret]
  elsif ret = @src.scan(CODE_OPEN_RE)
    @pre << ret
    [:CODE_OPEN, ret]
  elsif ret = @src.scan(CODE_CLOSE_RE)
    @pre << ret
    [:CODE_CLOSE, ret]
  elsif ret = @src.scan(VAR_OPEN_RE)
    @pre << ret
    [:VAR_OPEN, ret]
  elsif ret = @src.scan(VAR_CLOSE_RE)
    @pre << ret
    [:VAR_CLOSE, ret]
  elsif ret = @src.scan(KBD_OPEN_RE)
    @pre << ret
    [:KBD_OPEN, ret]
  elsif ret = @src.scan(KBD_CLOSE_RE)
    @pre << ret
    [:KBD_CLOSE, ret]
  elsif ret = @src.scan(INDEX_OPEN_RE)
    @pre << ret
    [:INDEX_OPEN, ret]
  elsif ret = @src.scan(INDEX_CLOSE_RE)
    @pre << ret
    [:INDEX_CLOSE, ret]
  elsif ret = @src.scan(REF_OPEN_RE)
    @pre << ret
    [:REF_OPEN, ret]
  elsif ret = @src.scan(REF_CLOSE_RE)
    @pre << ret
    [:REF_CLOSE, ret]
  elsif ret = @src.scan(FOOTNOTE_OPEN_RE)
    @pre << ret
    [:FOOTNOTE_OPEN, ret]
  elsif ret = @src.scan(FOOTNOTE_CLOSE_RE)
    @pre << ret
    [:FOOTNOTE_CLOSE, ret]
  elsif ret = @src.scan(VERB_OPEN_RE)
    @pre << ret
    [:VERB_OPEN, ret]
  elsif ret = @src.scan(VERB_CLOSE_RE)
    @pre << ret
    [:VERB_CLOSE, ret]
  elsif ret = @src.scan(BAR_RE)
    @pre << ret
    [:BAR, ret]
  elsif ret = @src.scan(QUOTE_RE)
    @pre << ret
    [:QUOTE, ret]
  elsif ret = @src.scan(SLASH_RE)
    @pre << ret
    [:SLASH, ret]
  elsif ret = @src.scan(BACK_SLASH_RE)
    @pre << ret
    [:BACK_SLASH, ret]
  elsif ret = @src.scan(URL_RE)
    @pre << ret
    [:URL, ret]
  elsif ret = @src.scan(OTHER_RE)
    @pre << ret
    [:OTHER, ret]
  else
    ret = @src.rest
    @pre << ret
    @src.clear
    [:OTHER, ret]
  end
end

def on_error(et, ev, values)
  line_num = @pre.to_a.size - 1
  if /\n/ =~ @src.rest
    next_words = $`
  else
    next_words = @src.rest
  end
  
  raise ParseError, <<Msg

RD syntax error: line #{@blockp.line_index - line_num}:
... #{(ev||'') + next_words} ...
   ^
    
Msg
end

##### racc 1.0.0 generates ###

racc_reduce_table = [
 0, 0, :racc_error,
 1, 27, :_reduce_none,
 2, 28, :_reduce_2,
 1, 28, :_reduce_3,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 1, 29, :_reduce_none,
 3, 30, :_reduce_13,
 3, 31, :_reduce_14,
 3, 32, :_reduce_15,
 3, 33, :_reduce_16,
 3, 34, :_reduce_17,
 4, 35, :_reduce_18,
 3, 35, :_reduce_19,
 2, 40, :_reduce_20,
 2, 40, :_reduce_21,
 1, 40, :_reduce_22,
 1, 40, :_reduce_23,
 2, 41, :_reduce_24,
 2, 41, :_reduce_25,
 1, 41, :_reduce_26,
 1, 41, :_reduce_27,
 2, 39, :_reduce_none,
 4, 39, :_reduce_29,
 2, 43, :_reduce_none,
 4, 43, :_reduce_31,
 1, 44, :_reduce_32,
 3, 44, :_reduce_33,
 1, 45, :_reduce_none,
 3, 45, :_reduce_35,
 2, 46, :_reduce_36,
 2, 46, :_reduce_37,
 1, 46, :_reduce_38,
 1, 46, :_reduce_39,
 1, 47, :_reduce_none,
 2, 51, :_reduce_41,
 1, 51, :_reduce_42,
 2, 53, :_reduce_43,
 1, 53, :_reduce_44,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 50, :_reduce_none,
 1, 54, :_reduce_none,
 1, 54, :_reduce_none,
 1, 55, :_reduce_none,
 1, 55, :_reduce_none,
 1, 56, :_reduce_55,
 1, 52, :_reduce_56,
 1, 57, :_reduce_57,
 2, 58, :_reduce_58,
 1, 58, :_reduce_none,
 2, 48, :_reduce_60,
 1, 48, :_reduce_none,
 2, 49, :_reduce_62,
 1, 49, :_reduce_none,
 1, 60, :_reduce_none,
 1, 60, :_reduce_none,
 1, 60, :_reduce_none,
 1, 60, :_reduce_none,
 1, 60, :_reduce_none,
 1, 62, :_reduce_none,
 1, 62, :_reduce_none,
 1, 59, :_reduce_none,
 1, 59, :_reduce_none,
 1, 61, :_reduce_none,
 1, 61, :_reduce_none,
 1, 61, :_reduce_none,
 2, 42, :_reduce_76,
 1, 42, :_reduce_none,
 1, 63, :_reduce_none,
 2, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 1, 63, :_reduce_none,
 3, 36, :_reduce_99,
 3, 37, :_reduce_100,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 1, 65, :_reduce_none,
 2, 66, :_reduce_107,
 1, 66, :_reduce_none,
 1, 38, :_reduce_109,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 1, 67, :_reduce_none,
 2, 67, :_reduce_129,
 2, 67, :_reduce_130,
 1, 67, :_reduce_none,
 2, 64, :_reduce_132,
 1, 64, :_reduce_none ]

racc_reduce_n = 134

racc_shift_n = 174

racc_action_table = [
   131,   132,   133,   135,   134,   136,   120,   119,   118,   100,
   130,   129,   128,   127,   126,   125,   124,   123,   122,   121,
   158,   117,   116,   131,   132,   133,   135,   134,   136,   120,
   119,   118,   139,   130,   129,   128,   127,   126,   125,   124,
   123,   122,   121,   160,   117,   116,   131,   132,   133,   135,
   134,   136,   120,   119,   118,   111,   130,   129,   128,   127,
   126,   125,   124,   123,   122,   121,   151,   117,   116,    50,
    49,    48,    32,    31,    51,    37,    35,    34,   100,    47,
    46,    45,    44,    43,    42,    41,    40,    39,    38,    36,
    33,    86,   131,   132,   133,   135,   134,   136,   120,   119,
   118,   146,   130,   129,   128,   127,   126,   125,   124,   123,
   122,   121,    87,   117,   116,     7,     6,     5,     4,     3,
     8,    11,    10,   167,   147,    16,    83,    15,   168,    14,
   169,    13,   170,    12,    82,   149,     9,     7,     6,     5,
     4,     3,     8,    11,    10,    84,   150,    16,   168,    15,
   148,    14,   nil,    13,   nil,    12,   nil,   nil,     9,     7,
     6,     5,     4,     3,     8,    11,    10,   nil,   nil,    16,
   nil,    15,   nil,    14,   nil,    13,   nil,    12,   nil,   nil,
     9,     7,     6,     5,     4,     3,     8,    11,    10,   nil,
   nil,    16,   nil,    15,   nil,    14,   nil,    13,   nil,    12,
   nil,   nil,     9,     7,     6,     5,     4,     3,     8,    11,
    10,   nil,   nil,    16,   nil,    15,   nil,    14,   nil,    13,
   nil,    12,   nil,   nil,     9,     7,     6,     5,     4,     3,
     8,    11,    10,   nil,   nil,    16,   nil,    15,   nil,    14,
   nil,    13,   nil,    12,    88,   nil,     9,    57,    90,    58,
    56,    55,    54,   nil,    16,   nil,    15,   nil,    14,   nil,
    13,   nil,    12,    69,   nil,     9,    57,    73,    58,    56,
    55,    54,   nil,    16,   nil,    15,   nil,    14,   nil,    13,
   nil,    12,   nil,   nil,     9,     7,     6,     5,     4,     3,
     8,    11,    10,   nil,   nil,    16,   nil,    15,   nil,    14,
   nil,    13,   nil,    12,   nil,   nil,     9,    50,    49,    48,
    32,    31,    51,    37,    35,    34,   nil,    47,    46,    45,
    44,    43,    42,    41,    40,    39,    38,    36,    33,     7,
     6,     5,     4,     3,     8,    11,    10,   nil,   nil,    16,
   nil,    15,   nil,    14,   nil,    13,   nil,    12,    88,   nil,
     9,    57,    90,    58,    56,    55,    54,   nil,    16,   nil,
    15,   nil,    14,   nil,    13,   nil,    12,    88,   nil,     9,
    57,    90,    58,    56,    55,    54,   nil,    16,   nil,    15,
   nil,    14,   nil,    13,   113,    12,   nil,    57,     9,    58,
    56,    55,    54,   nil,    16,   nil,    15,   nil,    14,   nil,
    13,   nil,    12,    88,   nil,     9,    57,    90,    58,    56,
    55,    54,   nil,    16,   nil,    15,   nil,    14,   nil,    13,
   nil,    12,   nil,   nil,     9,   102,   101,    57,    90,    58,
    56,    55,    54,   nil,    16,   nil,    15,   nil,    14,   nil,
    13,   nil,    12,   nil,   nil,     9,   102,   101,    57,    90,
    58,    56,    55,    54,   nil,    16,   nil,    15,   nil,    14,
   nil,    13,   nil,    12,   nil,   nil,     9,   102,   101,    57,
    90,    58,    56,    55,    54,   nil,    16,   nil,    15,   nil,
    14,   nil,    13,   nil,    12,   nil,   nil,     9,   157,   102,
   101,    57,    90,    58,    56,    55,    54,   140,   nil,   nil,
    57,   144,    58,    56,    55,    54,   163,   nil,   nil,    57,
   nil,    58,    56,    55,    54,    88,   nil,   nil,    57,    90,
    58,    56,    55,    54,   171,   102,   101,    57,    90,    58,
    56,    55,    54,    88,   nil,   nil,    57,    90,    58,    56,
    55,    54,   173,   102,   101,    57,    90,    58,    56,    55,
    54,   102,   101,    57,    90,    58,    56,    55,    54,   102,
   101,    57,    90,    58,    56,    55,    54,   102,   101,    57,
    90,    58,    56,    55,    54,     7,     6,     5,     4,     3,
     8 ]

racc_action_check = [
   166,   166,   166,   166,   166,   166,   166,   166,   166,    68,
   166,   166,   166,   166,   166,   166,   166,   166,   166,   166,
   110,   166,   166,   138,   138,   138,   138,   138,   138,   138,
   138,   138,    74,   138,   138,   138,   138,   138,   138,   138,
   138,   138,   138,   135,   138,   138,   144,   144,   144,   144,
   144,   144,   144,   144,   144,    70,   144,   144,   144,   144,
   144,   144,   144,   144,   144,   144,    82,   144,   144,    52,
    52,    52,    52,    52,    52,    52,    52,    52,   141,    52,
    52,    52,    52,    52,    52,    52,    52,    52,    52,    52,
    52,    52,    73,    73,    73,    73,    73,    73,    73,    73,
    73,    76,    73,    73,    73,    73,    73,    73,    73,    73,
    73,    73,    53,    73,    73,    16,    16,    16,    16,    16,
    16,    16,    16,   145,    77,    16,    32,    16,   157,    16,
   158,    16,   159,    16,    28,    79,    16,    13,    13,    13,
    13,    13,    13,    13,    13,    32,    80,    13,   171,    13,
    78,    13,   nil,    13,   nil,    13,   nil,   nil,    13,    14,
    14,    14,    14,    14,    14,    14,    14,   nil,   nil,    14,
   nil,    14,   nil,    14,   nil,    14,   nil,    14,   nil,   nil,
    14,    15,    15,    15,    15,    15,    15,    15,    15,   nil,
   nil,    15,   nil,    15,   nil,    15,   nil,    15,   nil,    15,
   nil,   nil,    15,    12,    12,    12,    12,    12,    12,    12,
    12,   nil,   nil,    12,   nil,    12,   nil,    12,   nil,    12,
   nil,    12,   nil,   nil,    12,    27,    27,    27,    27,    27,
    27,    27,    27,   nil,   nil,    27,   nil,    27,   nil,    27,
   nil,    27,   nil,    27,    99,   nil,    27,    99,    99,    99,
    99,    99,    99,   nil,    99,   nil,    99,   nil,    99,   nil,
    99,   nil,    99,    11,   nil,    99,    11,    11,    11,    11,
    11,    11,   nil,    11,   nil,    11,   nil,    11,   nil,    11,
   nil,    11,   nil,   nil,    11,    10,    10,    10,    10,    10,
    10,    10,    10,   nil,   nil,    10,   nil,    10,   nil,    10,
   nil,    10,   nil,    10,   nil,   nil,    10,     9,     9,     9,
     9,     9,     9,     9,     9,     9,   nil,     9,     9,     9,
     9,     9,     9,     9,     9,     9,     9,     9,     9,     0,
     0,     0,     0,     0,     0,     0,     0,   nil,   nil,     0,
   nil,     0,   nil,     0,   nil,     0,   nil,     0,    66,   nil,
     0,    66,    66,    66,    66,    66,    66,   nil,    66,   nil,
    66,   nil,    66,   nil,    66,   nil,    66,    67,   nil,    66,
    67,    67,    67,    67,    67,    67,   nil,    67,   nil,    67,
   nil,    67,   nil,    67,    72,    67,   nil,    72,    67,    72,
    72,    72,    72,   nil,    72,   nil,    72,   nil,    72,   nil,
    72,   nil,    72,    98,   nil,    72,    98,    98,    98,    98,
    98,    98,   nil,    98,   nil,    98,   nil,    98,   nil,    98,
   nil,    98,   nil,   nil,    98,    69,    69,    69,    69,    69,
    69,    69,    69,   nil,    69,   nil,    69,   nil,    69,   nil,
    69,   nil,    69,   nil,   nil,    69,   108,   108,   108,   108,
   108,   108,   108,   108,   nil,   108,   nil,   108,   nil,   108,
   nil,   108,   nil,   108,   nil,   nil,   108,   113,   113,   113,
   113,   113,   113,   113,   113,   nil,   113,   nil,   113,   nil,
   113,   nil,   113,   nil,   113,   nil,   nil,   113,   109,   109,
   109,   109,   109,   109,   109,   109,   109,    75,   nil,   nil,
    75,    75,    75,    75,    75,    75,   143,   nil,   nil,   143,
   nil,   143,   143,   143,   143,    94,   nil,   nil,    94,    94,
    94,    94,    94,    94,   162,   162,   162,   162,   162,   162,
   162,   162,   162,    59,   nil,   nil,    59,    59,    59,    59,
    59,    59,   172,   172,   172,   172,   172,   172,   172,   172,
   172,   140,   140,   140,   140,   140,   140,   140,   140,   154,
   154,   154,   154,   154,   154,   154,   154,   163,   163,   163,
   163,   163,   163,   163,   163,     2,     2,     2,     2,     2,
     2 ]

racc_action_default = [
  -134,  -108,  -109,  -106,  -105,  -104,  -103,  -102,  -101,  -134,
  -134,  -134,  -134,  -134,  -134,  -134,  -134,   -12,   -11,   -10,
    -9,    -8,    -7,    -6,    -5,    -4,    -3,    -1,  -134,  -107,
  -133,  -131,  -134,  -128,  -127,  -126,  -125,  -124,  -123,  -122,
  -121,  -120,  -119,  -118,  -117,  -116,  -115,  -114,  -113,  -112,
  -111,  -110,  -134,  -134,   -68,   -67,   -66,   -65,   -64,   -61,
   -50,   -49,   -48,   -47,   -46,   -45,   -38,   -39,   -56,  -134,
   -34,   -26,   -27,  -134,  -134,  -134,  -134,  -134,  -134,  -134,
  -134,    -2,  -134,  -130,  -129,  -132,  -100,   -99,   -72,   -71,
   -70,   -69,   -59,   -60,   -55,   -52,   -51,   -42,   -37,   -36,
   -30,   -75,   -74,   -73,   -63,   -54,   -53,   -44,   -40,   -57,
  -134,   -28,   -56,  -134,   -34,   -25,   -98,   -97,   -96,   -95,
   -94,   -93,   -92,   -91,   -90,   -89,   -88,   -87,   -86,   -85,
   -84,   -83,   -82,   -81,   -80,  -134,   -78,   -77,   -24,   -19,
  -134,   -32,   -22,   -23,  -134,  -134,   -17,   -16,   -15,   -14,
   -13,   174,   -58,   -41,   -57,   -43,   -62,  -134,   -35,  -134,
   -79,   -76,  -134,  -134,   -32,   -21,   -20,   -18,   -31,   -29,
   -35,   -33,  -134,   -33 ]

racc_action_pointer = [
   326,   nil,   572,   nil,   nil,   nil,   nil,   nil,   nil,   304,
   282,   260,   200,   134,   156,   178,   112,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   222,   134,   nil,
   nil,   nil,   120,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,    66,   101,   nil,   nil,   nil,   nil,   nil,   530,
   nil,   nil,   nil,   nil,   nil,   nil,   345,   364,     4,   421,
    51,   nil,   381,    89,     9,   494,    79,   104,   132,   119,
   132,   nil,    66,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   512,   nil,   nil,   nil,   400,   241,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   442,   485,
    17,   nil,   nil,   463,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   nil,    37,   nil,   nil,    20,   nil,
   547,    73,   nil,   503,    43,   100,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   nil,   555,   nil,   nil,   123,   126,   129,
   nil,   nil,   521,   563,   nil,   nil,    -3,   nil,   nil,   nil,
   nil,   143,   539,   nil ]

racc_goto_table = [
    68,    59,    67,   109,   138,   142,    72,    70,    71,   110,
    89,    30,   161,   156,    21,   153,   153,    89,    89,    98,
    99,    18,   152,   152,    21,   155,    21,    21,    21,    21,
    21,    18,    93,    18,    18,    18,    18,    18,    81,    75,
   161,    21,   145,    52,    89,    89,    29,    74,    18,    89,
    89,   nil,   nil,   159,    85,   nil,   nil,   nil,   156,   nil,
   106,   112,    59,    67,   141,    59,   156,    23,   114,   115,
   143,   nil,   nil,   165,   162,   166,   156,    23,   nil,    23,
    23,    23,    23,    23,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,    22,    23,   nil,   nil,   172,   nil,   106,
    25,   nil,   nil,    22,   106,    22,    22,    22,    22,    22,
    25,   nil,    25,    25,    25,    25,    25,   nil,   nil,   nil,
    22,   nil,   nil,   nil,    24,   nil,   nil,    25,   nil,   nil,
   nil,    28,   164,    59,    24,   nil,    24,    24,    24,    24,
    24,    53,   nil,    76,    77,    78,    79,    80,   nil,   nil,
   nil,    24 ]

racc_goto_check = [
    22,    34,    24,    23,    16,    18,    17,    20,    19,    21,
    36,    41,    37,    35,     8,    28,    28,    36,    36,    25,
    25,    11,    33,    33,     8,    29,     8,     8,     8,     8,
     8,    11,    32,    11,    11,    11,    11,    11,     3,    13,
    37,     8,    14,    38,    36,    36,    39,    15,    11,    36,
    36,   nil,   nil,    21,    41,   nil,   nil,   nil,    35,   nil,
    24,    22,    34,    24,    22,    34,    35,     6,    20,    19,
    17,   nil,   nil,    18,    23,    16,    35,     6,   nil,     6,
     6,     6,     6,     6,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,     7,     6,   nil,   nil,    23,   nil,    24,
     4,   nil,   nil,     7,    24,     7,     7,     7,     7,     7,
     4,   nil,     4,     4,     4,     4,     4,   nil,   nil,   nil,
     7,   nil,   nil,   nil,     5,   nil,   nil,     4,   nil,   nil,
   nil,     1,    22,    34,     5,   nil,     5,     5,     5,     5,
     5,     1,   nil,     1,     1,     1,     1,     1,   nil,   nil,
   nil,     5 ]

racc_goto_pointer = [
   nil,   131,   nil,    11,   100,   124,    67,    93,    14,   nil,
   nil,    21,   nil,    28,   -33,    36,   -69,    -5,   -70,    -3,
    -4,   -60,   -11,   -66,    -9,   -47,   nil,   nil,   -83,   -83,
   nil,   nil,   -27,   -71,   -10,   -96,   -49,  -126,    34,    44,
   nil,     2 ]

racc_goto_default = [
   nil,   nil,    27,    26,    65,    64,    63,    62,    61,    20,
    19,    60,    17,   nil,   nil,   nil,   nil,   nil,   nil,   nil,
   nil,   nil,   nil,   154,    96,   nil,    66,   108,    97,   107,
    95,   105,    94,    92,    91,   104,   103,   137,   nil,     1,
     2,   nil ]

racc_token_table = {
 false => 0,
 Object.new => 1,
 :EX_LOW => 2,
 :QUOTE => 3,
 :BAR => 4,
 :SLASH => 5,
 :BACK_SLASH => 6,
 :URL => 7,
 :OTHER => 8,
 :REF_OPEN => 9,
 :FOOTNOTE_OPEN => 10,
 :FOOTNOTE_CLOSE => 11,
 :EX_HIGH => 12,
 :EM_OPEN => 13,
 :EM_CLOSE => 14,
 :CODE_OPEN => 15,
 :CODE_CLOSE => 16,
 :VAR_OPEN => 17,
 :VAR_CLOSE => 18,
 :KBD_OPEN => 19,
 :KBD_CLOSE => 20,
 :INDEX_OPEN => 21,
 :INDEX_CLOSE => 22,
 :REF_CLOSE => 23,
 :VERB_OPEN => 24,
 :VERB_CLOSE => 25 }

racc_nt_base = 26

Racc_arg = [
 racc_action_table,
 racc_action_check,
 racc_action_default,
 racc_action_pointer,
 racc_goto_table,
 racc_goto_check,
 racc_goto_default,
 racc_goto_pointer,
 racc_nt_base,
 racc_reduce_table,
 racc_token_table,
 racc_shift_n,
 racc_reduce_n ]

Racc_debug_parser = false

##### racc system variables end #####


 # reduce 0 omitted

 # reduce 1 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 13 )
  def _reduce_2( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 14 )
  def _reduce_3( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 4 omitted

 # reduce 5 omitted

 # reduce 6 omitted

 # reduce 7 omitted

 # reduce 8 omitted

 # reduce 9 omitted

 # reduce 10 omitted

 # reduce 11 omitted

 # reduce 12 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 28 )
  def _reduce_13( val, _values, result )
				result = Emphasis.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 31 )
  def _reduce_14( val, _values, result )
				result = Code.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 34 )
  def _reduce_15( val, _values, result )
				result = Var.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 37 )
  def _reduce_16( val, _values, result )
				result = Keyboard.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 40 )
  def _reduce_17( val, _values, result )
				result = Index.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 47 )
  def _reduce_18( val, _values, result )
 result = Reference.new(val[2], val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 49 )
  def _reduce_19( val, _values, result )
 result = Reference.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 52 )
  def _reduce_20( val, _values, result )
 result = Reference::URL.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 54 )
  def _reduce_21( val, _values, result )
 result = Reference::RDLabel.new(val[1], val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 56 )
  def _reduce_22( val, _values, result )
 result = Reference::RDLabel.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 57 )
  def _reduce_23( val, _values, result )
 result = Reference::RDLabel.new(nil, val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 59 )
  def _reduce_24( val, _values, result )
 result = Reference::URL.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 61 )
  def _reduce_25( val, _values, result )
 result = Reference::RDLabel.new(val[1], val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 63 )
  def _reduce_26( val, _values, result )
 result = Reference::RDLabel.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 64 )
  def _reduce_27( val, _values, result )
 result = Reference::RDLabel.new(nil, val[0])
   result
  end
.,.,

 # reduce 28 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 68 )
  def _reduce_29( val, _values, result )
 result = val[1]
   result
  end
.,.,

 # reduce 30 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 73 )
  def _reduce_31( val, _values, result )
 result = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 78 )
  def _reduce_32( val, _values, result )
 result = [StringElement.new(val[0])]
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 80 )
  def _reduce_33( val, _values, result )
 result = [StringElement.new(val[1])]
   result
  end
.,.,

 # reduce 34 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 86 )
  def _reduce_35( val, _values, result )
 result = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 90 )
  def _reduce_36( val, _values, result )
 result = val[1].unshift(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 92 )
  def _reduce_37( val, _values, result )
 result = val[1].unshift(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 94 )
  def _reduce_38( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 95 )
  def _reduce_39( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 40 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 100 )
  def _reduce_41( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 101 )
  def _reduce_42( val, _values, result )
 result = val
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 104 )
  def _reduce_43( val, _values, result )
 result.push(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 105 )
  def _reduce_44( val, _values, result )
 result = val
   result
  end
.,.,

 # reduce 45 omitted

 # reduce 46 omitted

 # reduce 47 omitted

 # reduce 48 omitted

 # reduce 49 omitted

 # reduce 50 omitted

 # reduce 51 omitted

 # reduce 52 omitted

 # reduce 53 omitted

 # reduce 54 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 122 )
  def _reduce_55( val, _values, result )
 result = StringElement.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 125 )
  def _reduce_56( val, _values, result )
 result = StringElement.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 128 )
  def _reduce_57( val, _values, result )
 result = StringElement.new(val[0])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 132 )
  def _reduce_58( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 59 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 138 )
  def _reduce_60( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 61 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 142 )
  def _reduce_62( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 63 omitted

 # reduce 64 omitted

 # reduce 65 omitted

 # reduce 66 omitted

 # reduce 67 omitted

 # reduce 68 omitted

 # reduce 69 omitted

 # reduce 70 omitted

 # reduce 71 omitted

 # reduce 72 omitted

 # reduce 73 omitted

 # reduce 74 omitted

 # reduce 75 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 165 )
  def _reduce_76( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 77 omitted

 # reduce 78 omitted

 # reduce 79 omitted

 # reduce 80 omitted

 # reduce 81 omitted

 # reduce 82 omitted

 # reduce 83 omitted

 # reduce 84 omitted

 # reduce 85 omitted

 # reduce 86 omitted

 # reduce 87 omitted

 # reduce 88 omitted

 # reduce 89 omitted

 # reduce 90 omitted

 # reduce 91 omitted

 # reduce 92 omitted

 # reduce 93 omitted

 # reduce 94 omitted

 # reduce 95 omitted

 # reduce 96 omitted

 # reduce 97 omitted

 # reduce 98 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 196 )
  def _reduce_99( val, _values, result )
				result = Footnote.new(val[1])
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 199 )
  def _reduce_100( val, _values, result )
				result = Verb.new(val[1])
   result
  end
.,.,

 # reduce 101 omitted

 # reduce 102 omitted

 # reduce 103 omitted

 # reduce 104 omitted

 # reduce 105 omitted

 # reduce 106 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 213 )
  def _reduce_107( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 108 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 218 )
  def _reduce_109( val, _values, result )
 result = StringElement.new(val[0])
   result
  end
.,.,

 # reduce 110 omitted

 # reduce 111 omitted

 # reduce 112 omitted

 # reduce 113 omitted

 # reduce 114 omitted

 # reduce 115 omitted

 # reduce 116 omitted

 # reduce 117 omitted

 # reduce 118 omitted

 # reduce 119 omitted

 # reduce 120 omitted

 # reduce 121 omitted

 # reduce 122 omitted

 # reduce 123 omitted

 # reduce 124 omitted

 # reduce 125 omitted

 # reduce 126 omitted

 # reduce 127 omitted

 # reduce 128 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 241 )
  def _reduce_129( val, _values, result )
 result = val[1]
   result
  end
.,.,

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 242 )
  def _reduce_130( val, _values, result )
 result = val[1]
   result
  end
.,.,

 # reduce 131 omitted

 module_eval( <<'.,.,', 'rd/rdinlineparser.ry', 245 )
  def _reduce_132( val, _values, result )
 result << val[1]
   result
  end
.,.,

 # reduce 133 omitted

end
end # end of module RD

