=begin
= rdvisitor.rb
rdvisitor.rb defines a class RDVisitor. RDVisitor is a abstruct class
for visitor for RDTree.

== RDVisitor
RDVisitor is a abstruct class. This provides basic feature to class for
translation. 
=end

module RD
  class RDVisitor
    
    # must-have constants
    OUTPUT_SUFFIX = ""
    INCLUDE_SUFFIX = []
    
=begin
  --- RDVisitor.new
        (({RDVisitor.new})) doesn't need parameter defaultly. This
        constructer is redefined in sub class. When you override it,
        to call (({super})) is nice.
=end # '
    
    def initialize 
    end 

=begin
  --- RDVisitor#filename=(value)
        front-end can set file base name to use this method.
=end

    attr(:filename, true)
    
=begin
  --- RDVisitor#visit
        (({RDVisitor#visit})) call (({RDTree#accept})) normally.
        If you want, you can override (({RDVisitor#visit})) to preprocess.
        When you override it, to call (({super})) is nice.
=end
    def visit(tree)
      tree.accept(self)
    end
  
=begin
  --- RDVisitor#visit_XXX(element)
        In RDVisitor, visit_XXX trace children and call
        (({RDVisitor#apply_to_XXX})). If concrete visitor only translate,
        it have to simply redefine (({RDVisitor#apply_to_XXX})). Otherwise,
        it can redefine (({RDVisitor#visit_XXX})).
=end
    def visit_DocumentElement(element)
      blocks = []
      element.each_block do |i|
	blocks.push(i.accept(self))
      end
      apply_to_DocumentElement(element, blocks)
    end
  
    def visit_Headline(element)
      title = []
      element.title.each do |i|
	title.push(i.accept(self))
      end
      apply_to_Headline(element, title)
    end
  
    def visit_Include(element)
      apply_to_Include(element)
    end
  
    def visit_TextBlock(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_TextBlock(element, content)
    end
    
    def visit_Verbatim(element)
      apply_to_Verbatim(element)
    end
    
    def visit_ItemList(element)
      items = []
      element.each_item do |i|
	items.push(i.accept(self))
      end
      apply_to_ItemList(element, items)
    end
    
    def visit_EnumList(element)
      items = []
      element.each_item do |i|
	items.push(i.accept(self))
      end
      apply_to_EnumList(element, items)
    end
    
    def visit_DescList(element)
      items = []
      element.each_item do |i|
	items.push(i.accept(self))
      end
      apply_to_DescList(element, items)
    end

    def visit_MethodList(element)
      items = []
      element.each_item do |i|
	items.push(i.accept(self))
      end
      apply_to_MethodList(element, items)
    end

    def visit_ItemListItem(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_ItemListItem(element, content)
    end
    
    def visit_EnumListItem(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
    apply_to_EnumListItem(element, content)
    end
    
    def visit_DescListItem(element)
      description = []
      term = []
      element.term.each do |i|
	term.push(i.accept(self))
      end
      element.each_block_in_description do |i|
	description.push(i.accept(self))
      end
      apply_to_DescListItem(element, term, description)
    end

    def visit_MethodListItem(element)
      description = []
      term = apply_to_String(element.term) # MUST CHANGE!!
      element.each_block_in_description do |i|
	description.push(i.accept(self))
      end
      apply_to_MethodListItem(element, term, description)
    end
    
    def visit_StringElement(element)
      apply_to_StringElement(element)
    end
    
    def visit_Emphasis(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_Emphasis(element, content)
    end
    
    def visit_Code(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_Code(element, content)
    end
    
    def visit_Var(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_Var(element, content)
    end
    
    def visit_Keyboard(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_Keyboard(element, content)
    end
  
    def visit_Index(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_Index(element, content)
    end

    def visit_Reference(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_Reference(element, content)
    end

#    def visit_RefToElement(element)
#      apply_to_RefToElement(element)
#    end
    
#    def visit_RefToURL(element)
#      apply_to_RefToURL(element)
#    end
  
    def visit_Footnote(element)
      content = []
      element.each_child do |i|
	content.push(i.accept(self))
      end
      apply_to_Footnote(element, content)
    end
    
    def visit_Verb(element)
      apply_to_Verb(element)
    end

=begin
  --- RDVisitor#apply_to_XXX
        (({RDVisitor#apply_to_XXX})) must be redefined by sub class of
        (({RDVisitor})). If you want to write a simple visitor to translate
        RD into other format, you should redefine (({RDVisitor#apply_to_XXX})) 
        only.
=end

    def apply_to_Include(element)
      # Can visitor directly access file?
      includePath = element.tree.include_path
      catch(:found) do 
	includePath.each do |dir|
	  @include_suffix.each do |suffix|
	    file = dir + "/" + element.filename + "." + suffix
	    if test(?e, file)
	      throw(:found, IO.readlines(file).join(""))
	    end
	  end # @include_suffix.each
	end # includePath.each
	nil
      end # catch
    end # apply_to_Include
  end # RDVisitor

=begin
== module AutoLabel
this module provide automatical labeling feature to Visitors.
=end  
  module AutoLabel

=begin
  --- AutoLabel#prepare_labels(tree[, prefix])
        initialize method. call it before calling (({((<AutoLabel#refer>))}))
        ((|tree|)) is (({RDTree})), and ((|prefix|)) is a (({String})) which
        is used as target label prefix. default is (({"label:"})).
  
        if Visitor also include module (({RD::MethodParse})), (({AutoLabel}))
	make Ruby Reference Manual like label for MethodList.
=end
        
    def prepare_labels(tree, prefix = "label:")
      @__labels__ = {}
#      @__label_prefix__ = prefix

      # preprocessing for Reference
      headlines = tree.find_all do |i|
	i.is_a?(Headline)
      end
      desclists = tree.find_all do |i|
	i.is_a?(DescList)
      end
      methodlists = tree.find_all do |i|
	i.is_a?(MethodList)
      end
      
      headlines.each do |i|
	@__labels__[i.label] ||= prefix + @__labels__.size.to_s
      end
      desclists.each do |i|
	i.each_item do |j|
	  @__labels__[j.label] ||= prefix + @__labels__.size.to_s
	end
      end
      methodlists.each do |i|
	i.each_item do |j|
	  if self.respond_to?(:make_mindex_label, true)
	    @__labels__[j.label] ||= make_mindex_label(j)
	  else
	    @__labels__[j.label] ||= prefix + @__labels__.size.to_s
	  end
	end
      end
      @__labels__
    end
    private :prepare_labels
    
=begin
  --- AutoLabel#refer(label)
        return target label related with ((|label|)). you must call
        (({((<AutoLabel#prepare_labels>))})) beforehand. you can pass
        (({RD::RDElement})) as ((|label|)).
=end

    def refer(label)
      case label
      when RDElement
	label = label.to_label
      end
      if num = @__labels__[label]
	num
      else
	nil
      end
    end
    private :refer
  end # AutoLabel

=begin
== module RD::MethodParse
this module provide several functions for MehotList.
=end
  
  module MethodParse

=begin
  --- MethodParse#analize_method(method)
        parse ((|method|)) as Ruby method, and return it's klass, kind, method
        name and argment part as (({Array})).
=end
# '

    def analize_method(method)
      klass = nil
      args = nil
      kind = nil
      if /[^{(\s]+/ =~ method
	method = $&
	args = $'                   # '
      end

      if /^(.*)(#|::|\.)/ =~ method
	klass = $1
	kind = str2kind($2)
	method = $'                 # '
      end
      
      if klass == "function" and kind == :instance_method
	kind = :function
      end
      
      [klass, kind, method, args]
    end
    module_function :analize_method

=begin
  --- MethodParse#str2kind(str)
        translate character representation to method type.
          #  ->  :instance_method
          .  ->  :class_method
          :: ->  :constant
=end

    def str2kind(str)
      case str
      when '#'
	:instance_method
      when '.'
	:class_method
      when '::'
	:constant
      end
    end
    module_function :str2kind

=begin
  --- MethodParse#kind2str(kind)
        inverse of (({((<MethodParse#str2kind>))})).
=end
            
    def kind2str(int)
      case int
      when :instance_method, :function
	'#'
      when :class_method
	'.'
      when :constant
	'::'
      end
    end
    module_function :kind2str

=begin
  --- MethodParse#kind2num(kind)
        sort order of method type.
          :: < . < #
=end

    KIND2NUM = {:constant => 0, :class_method => 1, :instance_method => 2, :function => 2}
    def kind2num(str)
      KIND2NUM[str]
    end
    module_function :kind2num

=begin
  --- MethodParse#make_mindex_label(element)
        This method make labels for MethodList which is independent from
	output format. labels which is created with this method is made
	of only [a-zA-Z_]. each type of element is labeled such like:
	  * class methods, (({Class.method})) is labeled with,
	      Class_S_method
	  * instance methods, (({Class#method})) is labeled with,
	      Class_method
	  * constants, (({Class::CONST})) is labeled with,
	      Class_CONST
	  * functions, (({function#method})) is labeled with,
	      function_method
	
	if name of method end with "?", "!" or "=" , it is replaced with 
	"_p", "_bang" or "_eq". some exceptional name of method is labeled
	such like:
          Fig: special names and their labels
            Class#[]    -> Class_I_ref_
            Class#[]=   -> Class_I_set_
            Class#+     -> Class_I_plus_
            Class#+@    -> Class_I_uplus_
            Class#-     -> Class_I_minus_
            Class#-@    -> Class_I_uminus_
            Class#*     -> Class_I_mul_
            Class#/     -> Class_I_div_
            Class#%     -> Class_I_mod_
            Class#**    -> Class_I_power_
            Class#~     -> Class_I_inv_
            Class#==    -> Class_I_eq_
            Class#===   -> Class_I_eqq_
            Class#=~    -> Class_I_match_
            Class#&     -> Class_I_and_
            Class#|     -> Class_I_or_
            Class#<<    -> Class_I_lshift_
            Class#>>    -> Class_I_rshift_
            Class#<=>   -> Class_I_comp_
            Class#<     -> Class_I_lt_
            Class#<=    -> Class_I_le_
            Class#>     -> Class_I_gt_
            Class#=>    -> Class_I_ge_
            Class#^     -> Class_I_xor_
             
            function#`  -> function_backquote_ (only one)
=end        
       
    def make_mindex_label(element)
      klass, kind, method = analize_method(element.label)
      case kind
      when :class_method
	klass + "_S_" + tr_method(method)
      when :instance_method
	klass + "_" + tr_method(method)
      when :constant
	klass + "_" + method
      when :function
	"function_" + tr_method(method)
      else
	element.label
      end
    end
    module_function :make_mindex_label

    def tr_method(method)
      case method
      when "[]"
	"ref_"
      when "[]="
	"set_"
      when "+"
	"plus_"
      when "+@"
	"uplus_"
      when "-"
	"minus_"
      when "-@"
	"uminus_"
      when "*"
	"mul_"
      when "/"
	"div_"
      when "%"
        "mod_"
      when "**"
	"power_"
      when "~"
	"inv_"
      when "=="
	"eq_"
      when "==="
	"eqq_"
      when "=~"
	"match_"
      when "&"
	"and_"
      when "|"
	"or_"
      when "<<"
	"lshift_"
      when ">>"
	"rshift_"
      when "<=>"
	"cmp_"
      when "<"
	"lt_"
      when "<="
	"le_"
      when ">"
	"gt_"
      when ">="
	"ge_"
      when "^"
	"xor_"
      when "`"
	"backquote_"
      when /!$/
	$` + "_bang"     # `
      when /\?$/
	$` + "_p"        # `
      when /=$/
	$` + "_eq"       # `
      else
	method
      end
    end
    module_function :tr_method
    
    def make_method_index(tree)
      indexes = []
      tree.each do |i|
	if i.is_a?(MethodListItem)
	  klass, kind, method, args = analize_method(i.term)
	  indexes.push([klass, kind2num(kind), method, kind]) if kind
	end
      end
      indexes.sort!.each {|i| i[1] = i.pop}
    end
    module_function :make_method_index
	  
  end # MethodParse
end # RD

=begin
== script info.
 abstruct class for visitor of RDTree.
 $Id: rdvisitor.rb,v 1.1 2001/01/23 22:10:48 dave Exp $

== changes
:0.6.2
  * RMI bug caused by ruby-1.5's change of Symbol is fixed.
    thanks. > Nakada
:0.6.1
  * (({apply_to_Include}))'s bug fixed.
:0.6.0
  * MethodList. thanks. > Arai
  * (({AutoLabel})), (({MethodParse})) modules.
  * (({((<MethodParse#make_mindex_label>))})).
  * changes about changes of (({Reference})).
:0.5.3
  * (({((<RDVisitor#apply_to_Include>))})).
:0.5.2
  * into RD module.
  * (({RDVisitor#prepare_labels})). This include Hiwada's patch.
    thanks. > Hiwada
:0.5.0
  * added.
=end

