#/usr/bin/env ruby
#
# We have a problem with the automatically generated 
# index entries. Take the special variable $!
#
# We index this using \indexVariable{\$!}
#
# This generates \index{\$!@\texttt{\$!}}
#
# Two problems - the leading \ screws up the sort order. More
# significantly, the '!' is interpreted as a level separator.
#
# So... we changed the indexing macros to generate
#
#  \index{\tidy{<<\$!>>}@\texttt{\$!}}
#
# This code goes through the .idx file and replaces these
# \tidy directives with their content, but without the \ characters
# and with specqial characters escaped
#

GC.disable

$charMap = { '176' => '~', '134' => '\\', '136' => '^', '0' => '`' }


def processLine(line)
  line.gsub!(/\\Ikey\s*\{<<(.*?)>>\}/) do |match|
    field = $1
    
    field.gsub!(/\\dots/, '...')
    
    # remove escaping backslashes
    field.gsub!(/\\(.)/) { $1 }
    
    # quote special characters
    field.gsub!(/["!@|]/) { %{"#$&} }
    
    # remove the __ from __FILE__ etc
    field.gsub!(/__/, '')

    # convert \char.... to real character
    field.gsub!(/char '(\d+)relax\s*(\{\})?/) { #'
      raise "Unknown char #$1" unless ch = $charMap[$1]
      ch
    }

    field
  end
  
  line.gsub!(/\\Ivalue\s*\{<<(.*?)>>\}/) do |match|
    field = $1
    field.gsub!(/["!@|]/) { %{"#$&} }
      field
  end
  # and convert texttt\s+{{ to texttt{ so that
  # all keys collate
  line.gsub!(/\\texttt\s+\{/, '\\texttt{')

  print line
end





while gets
  gsub(/\\protect/, '')
  if /\\indexentry\{\\Ivar\s*\{<<(.*?)>>\}\}\{(\d+)\}/
    var = $1
    key = var.dup
    line = $2
    # remove escaping backslashes
    key.gsub!(/\\(.)/) { $1 }

    if key[0] == ?$
      key.sub!(/^\$/, '')
      processLine(
         "\\indexentry{\\Ikey{<<\\$ variables>>}@\\texttt{\\$} variables!" +
         "\\Ikey{<<#{key}>>}@\\texttt{\\Ivalue{<<#{var}>>}}}{#{line}}\n")
      key.sub!(/^-(.)/, '\1-')
    end

    if key =~ /^[a-zA-Z]/
      processLine("\\indexentry{\\Ikey{<<#{key}>>}@" +
                  "\\texttt{\\Ivalue{<<#{var}>>}} variable}{#{line}}\n");

      
    end


    processLine("\\indexentry{Variables!\\Ikey{<<#{var}>>}@" +
                "\\texttt{\\Ivalue{<<#{var}>>}}}{#{line}}\n");

  else
    processLine($_)
  end
end


