;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Some useful macros

;; Macros to detect what kind of Emacs is being run.
; Currently they are not used in the site configuration files 
; (they are supposed to be separate for different kinds of Emacs),
; but these macros can be used in personal ~/.emacs files.
(defmacro GNUEmacs (&rest x) "Evaluate body only if this is GNU Emacs running. Added in ALT's distribution."
  (list 'if (string-match "GNU Emacs " (version)) (cons 'progn x)))
(defmacro XEmacs (&rest x) "Evaluate body only if this is XEmacs 21 running. Added in ALT's distribution."
  (list 'if (string-match "XEmacs 21" (version)) (cons 'progn x)))
(defmacro GNUEmacs22 (&rest x) "Evaluate body only if this is GNU Emacs 22 running. Added in ALT's distribution."
  (list 'if (string-match "GNU Emacs 22" (version)) (cons 'progn x)))
(defmacro GNUEmacs21 (&rest x) "Evaluate body only if this is GNU Emacs 21 running. Added in ALT's distribution."
  (list 'if (string-match "GNU Emacs 21" (version)) (cons 'progn x)))

(defmacro Interactive-launch(&rest x) "Evaluate body only 
if Emacs has been launched with an interactive terminal (not in batch mode). 
Added in ALT's distribution."
  (list 'if (not noninteractive) (cons 'progn x)))

(defmacro Batch-launch(&rest x) "Evaluate body only 
if Emacs has been launched in the batch mode (without an interactive terminal).
Added in ALT's distribution."
  (list 'if noninteractive (cons 'progn x)))

;; Macro to detect if we are under X.
(defmacro Xlaunch (&rest x) "Evaluate body only if Emacs has been launched in X Window System. Added in ALT's distribution." 
  (Interactive-launch (list 'if (eq window-system 'x)(cons 'progn x))))
(defmacro TTYlaunch (&rest x) "Evaluate body only if Emacs has not been launched in any (e.g. X) Window System (i.e. when it is running in a terminal). Added in ALT's distribution." 
  (Interactive-launch (list 'if (null window-system)(cons 'progn x))))

; End of the useful macros
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
