;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Key bindings for selection manipulation

; These are the default bindings:

;; (global-set-key [S-delete] 'kill-region)
;; (global-set-key [C-insert] 'kill-ring-save)
;; (global-set-key [S-insert] 'yank)

; They are fine.


; Make the corresponding keys on the KeyPad behave the same way as
; their normal counterparts. We add them to function-key-map in order 
; for them to be translated into the normal keys.

(define-key function-key-map [S-kp-0]       [S-insert])
(define-key function-key-map [C-kp-0]       [C-insert])
(define-key function-key-map [S-kp-decimal] [S-delete])
(define-key function-key-map [C-kp-decimal] [C-delete])

; The same physical keys once more -- not to be dependent of NumLock state
; and other related strange interpretations of Shift+<a key from KeyPad>:

(define-key function-key-map [S-kp-insert] [S-insert])
(define-key function-key-map [C-kp-insert] [C-insert])
(define-key function-key-map [S-kp-delete] [S-delete])
(define-key function-key-map [C-kp-delete] [C-delete])

; You can still override the translation for KeyPad keys 
; caused by function-key-map; just make a specific setting like this:
;; (global-set-key [S-kp-0] (lambda () (interactive) (insert "A")))
;
; And to revert back to the standard behaviour:
;; (global-unset-key [S-kp-0])

; Shift-arrows a la windows...
(setq pc-select-meta-moves-sexps t)

(pc-selection-mode)

; Don't manipulate the selection when it is inactive
; (and thus not even highlighted).
(setq mark-even-if-inactive nil)


;; Turn on selection and change the default color
(setq transient-mark-mode 't highlight-nonselected-windows 't)


; Old bindings (can be found in emacs pkgs before 21.1-alt10) 
; for X selection manipulation.
; I don't see any reason to use them rather than the standard functions
; described above (they interact with X Window System, too).

;; (defun x-own-selection (s) (x-set-selection `PRIMARY s))
;; (global-set-key [(shift insert)] '(lambda () (interactive) (insert (x-get-selection))))
;; (global-set-key [(control insert)] '(lambda () (interactive) 
;; 				      (x-own-selection (buffer-substring (point) (mark)))))

;  End of the bindings for selection manipulation
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
