; -*- mode: emacs-lisp; -*-
;;; ALT's configuration for GNU Emacs, derived from
;;; Linux-Mandrake Configuration for GNU/Emacs.
; Chmouel Boudjnah <chmouel@mandrakesoft.com>
; Pixel <pixel@mandrakesoft.com>
; Frederic Lepied <flepied@mandrakesoft.com>
; Changes by AEN <aen@logic.ru>
; Changes by Ivan Zakharyaschev <imz@altlinux.ru> (Dec 2001, Feb 2002)
; Thanks to Oleg Tikhonov.
; Changes by Sergey Vlasov <vsu@altlinux.ru> (Oct 2002)

; See http://www.emacs.org/ for more information and configuration
; examples.

; Most (all!) of the distribution specific configuration
; that used to be here before
; now moved to site-start.d/0[01]*.el scripts.
;
; It has been split into small logical parts.
; This way it is easier for an administrator
; to customize each part and maintain them during package upgrades.
;
; The collection of options that were difficult to classify
; were put to site-start.d/10initial-features.el
;
;
; Here are the places where you may put configuration options for
; GNU Emacs:
; system-wide: this file, any of the existing /etc/emacs/site-start.d/*.el,
;   any new (created by you) /etc/emacs/site-start.d/*.el, 
;   /etc/X11/app-defaults/Emacs (and localized versions of this), 
;   /etc/X11/Xresources*;
; personal: ~/.emacs, ~/.Xdefaults.
;
;
; imz@altlinux.ru, February 2002.
;
;
; Added support for personal overrides of the whole site-start.el and
; specific startup files:
;
;  1) If ~/.emacs.d/site-start.el exists, it is loaded instead of
;     processing the rest of this file.  This way the user can turn
;     off automatic loading of the system startup files completely.
;
;  2) Startup *.el files are searched in ~/.emacs.d/site-start.d and
;     /etc/emacs/site-start.d; personal files override the system
;     startup files.  This way the user can turn off (or fix) the
;     offending startup file without disabling this startup system
;     altogether.
;
; vsu@altlinux.ru, October 2002

(if (file-exists-p (expand-file-name "~/.emacs.d/site-start.el"))

    ;; Just load the personal override file.
    (load-file "~/.emacs.d/site-start.el")

  ;; Load package or local system startup files.
  (let* (
	 ;; List of directories which are searched for the startup files.
	 (paths '("~/.emacs.d/site-start.d" "/etc/emacs/site-start.d"))

	 ;; Get a list of all the files in all the specified directories
	 ;; that match the pattern.
	 (all-files
	  (apply 'nconc
		 (mapcar #'(lambda (dir)
			     (condition-case nil
				 (directory-files dir t "^.*\\.el$" nil)
			       (error nil)))
			 paths)))

	 ;; Convert the file name list into the list of pairs
	 ;; (FILE-NAME-NONDIRECTORY . FULL-FILE-NAME).  Sort the list by
	 ;; the name part, in reverse order (the order is reversed back
	 ;; at the next step), stably (important for overriding).
	 (all-file-pairs
	  (sort
	   (mapcar #'(lambda (file)
		       (cons (file-name-nondirectory file) file))
		   all-files)
	   #'(lambda (a b)
	       (string< (car b) (car a)))))

	 ;; List of used files is built here.
	 (file-pairs nil))

    ;; Build list of all files (really the name and full name pairs)
    ;; which need to be loaded.  If several files have the same name
    ;; part, the first of them overrides all others.  This step
    ;; reverses the order again.
    (dolist (pair all-file-pairs)
      (unless (and file-pairs
		   (string= (car pair) (caar file-pairs)))
	(setq file-pairs (cons pair file-pairs))))

    ;; Load the required files.
    (dolist (pair file-pairs)
      (let ((file (cdr pair)))
	(if debug-on-error
	    (load-file file)
	  (condition-case nil
	      (load file nil)
	    (error (message "Error while loading %s" file))))))
    )

  )
