#!/bin/sh -e
#
# Copyright (C) 2003-2007  Dmitry V. Levin <ldv@altlinux.org>
# 
# The chrootuid2 helper for the hasher-priv project.
#
# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
#

n=
if [ -n "$1" -a -z "${1##-*}" ]; then
	n="$1"
	shift
fi

chroot_prefix=
if [ -n "$1" ]; then
	chroot_prefix="$1"
fi
mounted=
rm_ttydev=

killuid()
{
	/usr/libexec/hasher-priv/hasher-priv $n killuid
}

exit_handler()
{
	local rc=$1
	if [ -n "$chroot_prefix" -a -n "$mounted" ]; then
		/usr/libexec/hasher-priv/hasher-priv $n umount "$chroot_prefix" ||
			[ $rc = 0 ] || rc=1
	fi
	if [ -n "$rm_ttydev" ]; then
		rm -f "$chroot_prefix/dev/tty" "$chroot_prefix/dev/ptmx" ||
			[ $rc = 0 ] || rc=1
	fi
	killuid
	exit $rc
}

killuid

trap 'exit 143' HUP INT QUIT PIPE TERM
trap 'exit_handler $?' EXIT


need_maketty=
if [ -n "$chroot_prefix" -a -n "$mountpoints" ]; then
	for target in `printf %s "$mountpoints" |tr ',' ' '`; do
		/usr/libexec/hasher-priv/hasher-priv $n mount "$chroot_prefix" "$target" &&
			mounted=1 ||
			exit
		[ "$target" != /dev/pts ] || need_maketty=1
	done
fi

if [ -n "$need_maketty" ]; then
	/usr/libexec/hasher-priv/hasher-priv $n maketty "$chroot_prefix" &&
		rm_ttydev=1 ||
		exit
fi

/usr/libexec/hasher-priv/hasher-priv $n chrootuid2 "$@"
