ЧТО ЭТО ? (about)
=================

make-initrd - это реализация создания образов initramfs. Проект состоит из
двух основных частей:
* утилиты создания образа initramfs (make-initrd);
* утилит, работающих внутри образа в момент загрузки (назовём их initrd/init).

Утилита создания образа имеет модульную структуру. Оснавная её идея такова,
что для создания образа необходимо (в простейшем случае) указать список
особенностей (фич) будущего образа. При этом порядок указания совершенно
неважен. Пользователь не обязан знать, как и в каком порядке будут применяться
стадии. Ему важно, чтобы, например, образ имел нужные модули, имел bootspalsh
и был сжат.

ЗАВИСИМОСТИ (requirements)
==========================

Для своей работы make-initrd использует GNU make, чтобы легко создавать и
правильно обрабатывать зависимости между модулями.

Большинство скриптов сборки образа используют libshell - набор часто
используемых в shell функций.

kinit-utils - Набор утилит из klibc, спортированные на glibc. Эти утилиты имеют
широкий функционал и маленькие размеры (даже будучи собранными с glibc).

module-init-tools - Набор утилит для загрузки и поиска модулей ядра.

ПАРАМЕТРЫ (parameters)
======================

Параметры указываются в файле /etc/initrd.mk. Этот файл является
конфигурационным файлом для make-initrd.

KERNEL        - Устанавливает версию ядра, для которого будет собираться образ.

IMAGEFILE     - Файл, в который должен быть записан образ.

COMPRESS      - Определяет способ сжатия образа. Допустимые значения:
                gzip, bzip2, lzma, lzo.
                Если переменная имеет пустое значение, то сжатие производиться
                не будет.
                (см. раздел ОСОБЕННОСТИ).

FEATURES      - Этот параметр перечисляет список особенностей образа. Этот
                список может быть указан в произвольном порядке.
                (см. раздел ОСОБЕННОСТИ).

                Например: FEATURES = compress cleanup

                Список указывает, что после создания образа его необходимо
                сжать определённым способом, а затем удалить все временные файлы,
		появившиеся во время создания образа.

AUTODETECT    - В этой переменной перечисляются подсистемы, для которых
                автоматически будут находиться модули ядра и добавляться фичи.
                Если эта переменная будет пустой, то автодетект будет отключён.
                В данный момент доступны следующие мождули:

                root   - будут найдены модули для устройства, на котором
                         находится корневая файловая система, и модули самой
                         файловой системы (если они не собраны в ядро);

                resume - будут добавлены модули для устройства, с которого
                         происходит resume. Это бывает полезно, если это
                         устройство зашифровано или находится в неожиданном
                         месте.

                common - добавляет фичи общего назначения. Если вы не знаете
                         точно, что делаете, то не отключайте эту особенность.

                net    - будут добавлены модули ядра для загрузки сетевых
                         устройств (в терминах sysfs это /sys/class/net/*).
                         Вы можете указать дополнительные параметры, чтобы
                         добавить модули только для определённого сетевого
                         интерфейса:

                         net:iface=<iface> - указывает имя интерфейса, для
                         которого будет добавлен модуль ядра;

                kbd    - добавляет модули для клавиатуры;

                device - будут добавлены модули, необходимые для использованияa
                         устройства. В качестве параметра необходимо указать
                         путь к устройству на файловой системе sysfs (без
                         /sys). Например:

                         device:/block/sr0

                Помните, что переменные в make обрабатываются особым образом.
                Если TEXT содержит пробелы и вы хотите сохранить значение
                именно таким, то вам нужно использовать _одинарные_ (')
                кавычки.
                (см. раздел ОСОБЕННОСТИ).

MODULES_ADD   - Параметр перечисляет имена модулей, которые должны быть
                добавлены в образ.
                (см. раздел ОСОБЕННОСТИ).

MODULES_LOAD  - Параметр перечисляет имена модулей, которые должны быть
                добавлены в образ и загружены ПОСЛЕ старта udevd.
                (см. раздел ОСОБЕННОСТИ).

MODULES_PRELOAD - Параметр перечисляет имена модулей, которые должны быть
                добавлены в образ и загружены ДО старта udevd.
                (см. раздел ОСОБЕННОСТИ).

VERBOSE       - Включает отладочную информацию.

FIRMWARE_DIRS - В этой переменной перечислены директории, в которых будут
                искаться firmware.

PUT_FILES     - Этот параметр описывает список файлов, которые необходимо
                положить в образ initrd. Файлы копируются по тому же пути,
                что и исходный файл.
                Например:

                PUT_FILES += /usr/bin/less

                скопирует файл /usr/bin/less в initrd:/usr/bin/less

PUT_DIRS      - Этот параметр описывает список директорий, содержимое которых
                будет скопировано в образ.

ОСОБЕННОСТИ (features)
======================

Особенности - это части функционала, которые выполняются при создании образа или
во время загрузки (см. FEATURES).

add-modules   - Установить (см. MODULES_ADD) или установить и добавить к
                загрузке (см. MODULES_LOAD, MODULES_PRELOAD) дополнительные
                модули ядра.

bootsplash    - Добавить в образ splash.

devmapper     - Добавить поддержку device-mapper'а. Это особенность также
                добавляется при искользовании luks или lvm.

raid          - Добавить в образ утилиты и модули для загрузки корневой файловой
                системы с RAID.

luks          - Добавить в образ утилиты для загрузки с шифрованного раздела.

lvm           - Добавить в образ утилиты для загрузки корневой файловой системы
                с LVM.

nfsroot       - Добавить в образ утилиты для загрузки корневой файловой системы
                с NFS.

compress      - Сжать образ определённым алгоритмом (см. COMPRESS).

cleanup       - Удалить временные файлы, созданные make-initrd в процессе
                создания образа. Иногда очень удобно посмотреть, что и как было
                создано.

lazy-cleanup  - Удалять временные файлы не после, а до создания образа. Бывает
                полезно при отладке.

Цели (targets)
==============

Существует ряд специальных целей, которые очень полезны при генерации образа.

guess-config  - При вызыве этой цели на экран (stdout) предполагаемый конфиг.
                Он составляется исходя из вашей текущей конфигурации и списка
                особенностей, перечисленых в переменной AUTODETECT.

                Эта цель удобна для создания первоначального конфига в новой
                системе.

                Например:

                # make-initrd guess-config
                MODULES_ADD	+= ahci ext3 libata scsi_mod sd_mod
                FEATURES	+= add-modules compress cleanup

		# AUTODETECT='root common kbd' make-initrd guess-config
		MODULES_ADD	+= ahci evdev ext3 libata scsi_mod sd_mod serio_raw
		FEATURES	+= add-modules compress cleanup

                # AUTODETECT='net:iface=wlan0' make-initrd guess-config
                MODULES_ADD	+= cfg80211 iwlagn iwlcore led-class mac80211 rfkill
                FEATURES	+= add-module

bug-report    - Цель собирает данные о конфигурации системы и запаковывет
                их в архив. Если у вас возникают проблемы с работой make-initrd,
                то эта цель поможет собрать информацию, необходимую
                разработчикам, для устранения ошибки.

Структура каталогов
===================

features   - Каталог содержит параметры и правила различных особенностей.

data       - Тут находятся скрипты, выполняющиеся в процессе загрузки.

docs       - Каталог с документацией.

tools      - Здесь находятся вспомогательные утилиты.

src        - Также вспомогательные утилиты, но реализованные на Си.

             gen_init_cpio - Эта утилита взята из ядра. Она позволяет создавать
                             cpio-образ.

Процесс загрузки initrd
=======================

Init-скрипт находится в корне образа (/init). Процесс загрузки разбит
на несколько стадий (их количество не регламентировано жестко).
Init-скрипт выполняет скрипты из директории (/modules). Перед выполнением
каждой стадии выболняются скрипты (если они есть) из директории
/scripts/pre/<stage-name>/ и после её выполнения из директории
/scripts/post/<stage-name>/.

Основной иструмент в initrd - это udev. Всё (или почти всё) делается через
правила udev... настройка сети, монтирование корневой директории. Всё.
Обработчики, которые вызываются из правил udev, находятся в /lib/udev-helpers.

Параметры init:

init=<prog>            - параметр определяет программу init;

quiet=<1|0>            - включает/отключает отладочные сообщения;

panic=<1|0>            - разрешает/запрещает получение консоли при аварийных
                         ситуациях;

stop=<stage-list>      - параметр определяет список стадий, перед которыми
                         необходимо предаставить консоль;

ignore=<stage-list>    - определяет список стадий, которые нужно пропустить;

ip=<ip-spec>           - параметр описывает конфигурацию сетевых интерфейсов;
                         описание может быть коротким и длинным.

Длинное описание:

ip=<client-ip>:<server-ip>:<gw-ip>:<netmask>:<hostname>:<device>:<proto>

Короткое описание:

ip=<device>:<proto>

iptimeout=<sec>        - время за которое инициализируется сетевой интерфейс;

resume={<device>|UUID=...|LABEL=...}
                       - параметр определяет устройство, с которого будет
                         производиться восстановление после спящего режима.

root={<device>|UUID=...|LABEL=...|/dev/nfs}
                       - параметр определяет устройство, на котором находится
                         корневая файловая система.

rootdelay=<sec>        - определяет время ожидания корневой файловой системы.
                         Если за это время корень не будет найден, то загрузка
                         продолжена не будет. По умолчанию этот параметр
                         составляет 180 секунд.

-- 
legion 2009
