#!/bin/sh -e
#
# Usage:
# $ export LESSHIGHLIGHT=1
# $ less -R /path/to/file # file highlighted.
# $ less /path/to/file    # file without highlighting.

if [ -n "${LESSHIGHLIGHT-}" -a -n "${LESSCOLOR-}" -a -x /usr/bin/highlight ]; then
	format=
	case "$filetype" in
		*C\ program\ text*)	format='C++'	;;
		*XML*\ document\ text)	format='xml'	;;
		*shell\ script\ text*)	format='sh'	;;
		*TeX\ document\ text*)	format='tex'	;;
	esac

	case "$filename" in
		*.awk)			format='awk'	;;
		*.css)			format='css'	;;
		*.java)			format='java'	;;
		*.js)			format='js'	;;
		*.rb)			format='rb'	;;
		*.spec)			format='spec'	;;
	esac

	[ -z "$format" ] ||
		{ cmd="/usr/bin/highlight"; cmd_args=" -AS $format"; }
fi
