VERSION		 = 0.7.9

# Temprary directory used for processing all images.
# It is created once when the make-initrd starts.
TEMPDIR		?=

ifeq "$(TEMPDIR)" ''
$(error TEMPDIR is empty. You SHOULD NOT use config.mk directly.)
endif

# This is the working directory for each image.
# It is created for each configuration file.
WORKDIR_SUFFIX	?= work
WORKDIR		 = $(TEMPDIR)/$(KERNEL).$(WORKDIR_SUFFIX)

# This is the root directory of the image.
ROOTDIR		 = $(WORKDIR)/img

# In this directory are files received from autodetect.
GUESSDIR	 = $(WORKDIR)/guess

# This is directory used for bug-report target.
REPORTDIR	 = $(WORKDIR)/report

TOOLSDIR	 = /usr/share/make-initrd/tools
DATADIR		?= /usr/share/make-initrd/data
SCRIPTDIR	?= /usr/share/make-initrd/scripts.d
FEATURESDIR	?= /usr/share/make-initrd/features
BOOTDIR		?= /boot
SYSCONFDIR	?= /etc
SYSFS_PATH	?= /sys

PATH		= $(TOOLSDIR):$(shell echo $$PATH)

# Config file locations
INITRD_CONFIG		?=
INITRD_CONFIG_LIST	?= $(wildcard $(SYSCONFDIR)/initrd.mk $(SYSCONFDIR)/initrd.mk.d/*.mk)


# Global variables
RESOLVE_MODALIAS	?= 1
UDEV_VERSION		?= $(shell udevd --version)
KERNEL			?= $(shell uname -r)
KERNEL_CONFIG           ?= $(BOOTDIR)/config-$(KERNEL)
KERNEL_MODULES          ?= /lib/modules/$(KERNEL)/kernel
ARCH                    ?= $(shell uname -m)

ifeq "$(ARCH)" 'x86_64'
LIBNAME			= lib64
else
LIBNAME			= lib
endif

# This user's preferences are make sence only if user's config file is loaded.
ifneq "$(INITRD_CONFIG)" ''

# User defaults
FEATURES		?=
DISABLE_FEATURES	?= systemd
IMAGE_SUFFIX		?=
IMAGEFILE		?= $(BOOTDIR)/initrd-$(KERNEL)$(IMAGE_SUFFIX).img
FIRMWARE_DIRS		?= /lib/firmware/updates /lib/firmware /lib/firmware/$(KERNEL)/updates /lib/firmware/$(KERNEL)
VERBOSE			?=
DEVICES			?=
MOUNTPOINTS		?= /
FSTAB			?= /etc/fstab
BLACKLIST_MODULES	?=

# Load system configuration
include /usr/share/make-initrd/initfiles.mk

# Load user configuration
include $(INITRD_CONFIG)

# This is helper to filter a disabled files.
wildcard_features = \
	$(filter-out \
		$(foreach exl,$(DISABLE_FEATURES),$(realpath $(exl:%=$(FEATURESDIR)/%/$(1)))), \
		$(realpath $(wildcard $(FEATURESDIR)/*/$(1))))

# Load extra configs
feature_configs		 = $(call wildcard_features,config.mk)
ifeq "$(feature_configs)" ''
$(error Cannot find configs for feature. Something goes wrong.)
endif
include $(feature_configs)

# Guess variables
GUESS_FSTYPE_SCRIPTS	= $(call wildcard_features,guess/fstype)
GUESS_DEVICE_SCRIPTS	= $(call wildcard_features,guess/device)
GUESS_COMMON_SCRIPTS	= $(call wildcard_features,guess/common)

endif # INITRD_CONFIG

ifdef VERBOSE
  verbose=-v
  Q=
else
  Q = @
endif

