.EXPORT_ALL_VARIABLES:
.DEFAULT_GOAL := all

include /usr/share/make-initrd/config.mk
include /usr/share/make-initrd/rules.mk

ifneq "$(strip $(INITRD_CONFIG))" ''

# Load guessed parameters
ifeq ($(MAKECMDGOALS),genimage)
include $(GUESSDIR)/guessed.mk
endif

# Load requested features
ifneq "$(strip $(FEATURES))" ''
include $(call require,$(FEATURES))
endif # FEATURES

else # !INITRD_CONFIG

public_goals  = all guess-config guess-modules bug-report
private_goals = $(filter-out $(public_goals),$(MAKECMDGOALS))

ifneq "$(private_goals)" ''
    $(error You MUST NOT call private goals directly: $(private_goals))
endif
endif # INITRD_CONFIG

all: check-for-root
	@rc=0; \
	for c in $(INITRD_CONFIG_LIST); do \
		echo "Config file: $$c"; \
		wsuffix="$${c##*/}"; \
		wsuffix="$${wsuffix%.mk}"; \
		export WORKDIR_SUFFIX="$$wsuffix"; \
		export INITRD_CONFIG="$$c"; \
		$(TOOLSDIR)/run-make $(MAKE) $(MFLAGS) -f /usr/share/make-initrd/make-initrd.mk guess    || { rc=1; break; }; \
		export IGNORE_DEPMOD=1; \
		$(TOOLSDIR)/run-make $(MAKE) $(MFLAGS) -f /usr/share/make-initrd/make-initrd.mk genimage || { rc=1; break; }; \
	done; \
	rm -f -- $(TEMPDIR)/images; \
	exit $$rc

guess: depmod-host check-for-root
	@mkdir -m 755 -p -- $(GUESSDIR)
	@cat /dev/null > $(GUESSDIR)/modules
	@cat /dev/null > $(GUESSDIR)/modalias
	@cat /dev/null > $(GUESSDIR)/features
	@for i in $(AUTODETECT); do \
		mod="$$i"; \
		arg=""; \
		if [ -z "$${i##*:*}" ]; then \
			mod="$${i%%:*}"; \
			arg="$${i#*:}"; \
		fi; \
		if [ -x "$(TOOLSDIR)/guess-$$mod" ]; then \
			"$(TOOLSDIR)/guess-$$mod" "$$arg"; \
		else \
			echo "Warning: Unknown guessing module: $$mod" >&2; \
		fi; \
	done
	@$(TOOLSDIR)/guess-config > $(GUESSDIR)/guessed.mk

guess-config: AUTODETECT ?= common root resume
guess-config: check-for-root guess
	@cat $(GUESSDIR)/guessed.mk
	$Qrm -rf -- "$(GUESSDIR)"
	$Qrmdir -- "$(WORKDIR)"

guess-modules: AUTODETECT = root device
guess-modules: check-for-root guess
	@cat $(GUESSDIR)/modules $(GUESSDIR)/modalias | \
	   xargs -r depinfo \
	      --set-version="$(KERNEL)" \
	      --no-prefix \
	      --no-firmware \
	      --no-builtin \
	      2>/dev/null | \
	   sort -u
	$Qrm -rf -- "$(GUESSDIR)"
	$Qrmdir -- "$(WORKDIR)"

bug-report: check-for-root
	@mkdir -m 755 -p -- $(REPORTDIR)
	@$(TOOLSDIR)/bug-report
	$Qrm -rf -- "$(REPORTDIR)"
	$Qrmdir -- "$(WORKDIR)"
