#ifndef ADMFS_CONDUCTOR_HH__
#define ADMFS_CONDUCTOR_HH__

#include <map>
#include <string>

#include <admfs/singleton.hh>
#include <admfs/runtime_info.hh>

namespace admfs
{
    typedef	std::vector<std::string>		dirent_vector;
    typedef	std::map<std::string,runtime_info>	supporter_map;

    class conductor_impl
    {
	public:
	    conductor_impl() {}
	    void list(const std::string&,dirent_vector&);/**< get list of available objects*/
	    bool exists(const std::string&); /**< check that such supporter exists? */
	    bool add_plugin(const std::string&); /**< try to add plugin */
	    void del_plugin(const std::string&); /**< delete plugin */
	    void destroy(const std::string&); /**< destroy some object */
	    bool open(const std::string&,int); /**< prepare information about some object */
	private:
	    /**
	     * mapping: supporter --> runtime information
	     */
	    supporter_map supporters_;
    };

    typedef singleton_holder<conductor_impl> conductor;

}

#endif
