#ifndef ALT_UTILS_ASSERT_HH__
#define ALT_UTILS_ASSERT_HH__

namespace alt
{

	/**
	 * generate exception if assert failed
	 * @param expr failed expression
	 * @param file file name where assert failed
	 * @param line line where assert failed
	 */
	void make_glibc_assert(const std::string &expr, const std::string& file, int line);

	/**
	 * simple assertion for all glibc like fails (!=0)
	 */
#define GLIBC_ASSERT(expr) \
if ( (expr) < 0 ) alt::make_glibc_assert( #expr, __FILE__, __LINE__)

}

#endif // UTILS_ASSERT_HH__
