/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2003,2004 ALT Linux Ltd.
 *  Copyright (c) 2003,2004 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#ifndef UTILS_OS_HH
#define UTILS_OS_HH

#include <stdexcept>
#include <string>
#include <vector>
#include <cerrno>
#include <csignal>
#include <sys/types.h>
#include <unistd.h>

namespace err
{
	struct sys: public std::runtime_error
	{
		sys(): std::runtime_error(strerror(errno)) {}
		sys(int e): std::runtime_error(strerror(e)) {}
	};
}

namespace alt
{
	struct proc_stat
	{
		proc_stat(pid_t, int);

		pid_t pid;
		int status;
		int signal;
		unsigned exited;
		unsigned signaled;
		unsigned stopped;
	};

	enum wait_hang {hang = 0, nohang = 1};
	enum wait_traced {traced = 0, untraced = 1};

	pid_t fork(void);
	void setuid(uid_t uid);
	void setgid(gid_t gid);
	uid_t uid_by_name(const std::string& name);
	gid_t gid_by_name(const std::string& name);
	void pipe(int& in, int& out);
	void dup2(int old_fd, int new_fd);
	void exec(const std::string&);
	template <typename I> void exec(const std::string&, I, I);
	proc_stat wait(void);
	proc_stat wait(pid_t, wait_hang = hang, wait_traced = traced);
	void kill(pid_t, int);
}

template <typename I> void alt::exec(const std::string& cmd, I first, I last)
{
	std::vector<const char *> args(first, last);
	args.push_back(0);
	::execvp(cmd.c_str(), const_cast<char * const *>(&args[0]));
	throw err::sys();
}

#endif // UTILS_OS_HH
