#include <cerrno>

#include <sstream>
#include <stdexcept>
#include <utils/assert.hh>

using namespace std;

void alt::make_glibc_assert(const string &expr, const string& file, int line)
{
	ostringstream ost;
	ost << "Assertion '" << expr << "'" << std::endl;
	ost << "error:" << std::strerror(errno) << std::endl;
	ost << "failed at file:" << file << ":" << line;
	throw runtime_error(ost.str());
}
