/*
 *  ALTerator - ALT Linux configuration project
 *
 *  Copyright (c) 2003,2004 ALT Linux Ltd.
 *  Copyright (c) 2003,2004 Alexey Voinov
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 *  USA.
 */
#include <utils/os.hh>
#include <utils/str.hh>
#include <sys/wait.h>

void
alt::exec(const std::string& cmd)
{
	args_iterator i(cmd);
	alt::exec(*i, i, args_iterator());
}

alt::proc_stat::proc_stat(pid_t pid_, int status_)
	: pid(pid_),
	  exited(WIFEXITED(status)),
	  signaled(WIFSIGNALED(status)),
	  stopped(WIFSTOPPED(status))
{
	if(exited) status = WEXITSTATUS(status);
	if(signaled) signal = WTERMSIG(status);
	if(stopped) signal = WSTOPSIG(status);
}

alt::proc_stat alt::wait(void)
{
	int status;
	pid_t pid = ::wait(&status);
	if(pid == -1) throw err::sys();
	return proc_stat(pid, status);
}

alt::proc_stat alt::wait(pid_t pid, wait_hang opt1, wait_traced opt2)
{
	int status;
	pid = ::waitpid(pid, &status,
			(opt1 ? WNOHANG : 0) | (opt2 ? WUNTRACED : 0));
	if(pid == -1) throw err::sys();
	return proc_stat(pid, status);
}
