/*
*  ALTerator - ALT Linux configuration project
*
*  Copyright (c) 2003 ALT Linux Ltd.
*  Copyright (c) 2003 Alexey Voinov
*  Copyright (c) 2003 Alexander V. Nikolaev
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
*  USA.
*/
#include <locale>
#include <cctype>

#include <boost/bind.hpp>

#include <utils/str.hh>


//////////////////FROM CLASSIC LIBUTILS

using namespace std;

string alt::trim_left(const string& str,const std::string& trimchars)
{
	string::size_type pos = str.find_first_not_of(trimchars);
	return pos == string::npos ? "" : str.substr(pos);
}

string alt::trim_right(const string& str,const std::string& trimchars)
{
	string::size_type pos = str.find_last_not_of(trimchars);
	return pos == string::npos ? "" : str.substr(0, pos + 1);
}

string alt::trim(const string& str,const std::string& trimchars)
{
	return trim_right(trim_left(str,trimchars),trimchars);
}

std::string alt::to_lower(std::string str)
{
	std::transform(str.begin(), str.end(), str.begin(),
		       boost::bind(&std::tolower<char>, _1, std::locale::classic()));
	return str;
}

std::string alt::to_upper(std::string str)
{
	std::transform(str.begin(), str.end(), str.begin(),
		       boost::bind(&std::toupper<char>, _1, std::locale::classic()));
	return str;
}

std::string alt::cut_until_slash(std::string& str)
{
	std::string::size_type pos = str.find("/");
	std::string result = str.substr(0, pos);
	str.erase(0, pos == std::string::npos ? pos : pos + 1);
	return result;
}

std::string alt::cut_tail_until_slash(std::string& str)
{
	std::string::size_type pos = str.rfind("/");
	std::string result = str.substr(pos);
	str.erase(pos == std::string::npos ? pos : pos + 1);
	return result;
}

std::string alt::strip_slash(const std::string& str)
{
	return *str.rbegin() == '/' ? str.substr(0, str.size() - 1) : str;
}

std::string alt::ensure_slash(const std::string& str)
{
	return *str.rbegin() == '/' ? str : str + '/';
}

char *alt::strdup(const std::string& str)
{
	return ::strdup(str.c_str());
}

/////////////FROM NEW LIBALTUTILS
bool alt::char_before_is_esc(const std::string& line,
					std::string::size_type pos)
{
	if(line.empty() || pos == 0 || pos > line.size()) return false;
	if(pos != std::string::npos) return line[pos - 1] == '\\';
	return *line.rbegin() == '\\';
}

void alt::remove_esc_before_char(std::string& line, std::string::size_type pos)
{
	if(line.empty() || pos < 1 || pos > line.size()) return;
	if(line[pos - 1] == '\\') line.erase(pos - 1, 1);
}

std::string alt::split_on_unescaped_space(std::string& line)
{
	if(line.empty()) return "";
	std::string::size_type pos = 0;
	while(true)
	{
		pos = line.find_first_of(" \t", pos);
		if(!char_before_is_esc(line, pos)) break;
		if(pos == std::string::npos) break;
		remove_esc_before_char(line, pos);
	}
	std::string::size_type pos2 = line.find_first_not_of(" \t", pos);
	std::string ans = line.substr(0, pos);
	line.erase(0, pos2);
	return ans;
}
