#include <iostream>

//debug
#include <utils/os.hh>


#include <admfs/conductor.hh>
#include <admfs/support.hh>

#include <fuse.h>

using namespace admfs;

/**
 * we assume that first level files are directories, and
 * all directories contains only files
 */
static
int admfs_getattr(const char *path, struct stat *stbuf)
{
    int res = 0;

    std::cerr<<"admfs_getattr:"<<path<<std::endl;

    memset(stbuf, 0, sizeof(struct stat));

    if (!(conductor::instance().exists(path))) //note: real checking for plugins only
	return -ENOENT;

    //all first level is directories
    if(dir_level(path) < 3) {
        stbuf->st_mode = S_IFDIR | 0755;
        stbuf->st_nlink = 2;
    }
    //all others are files
    else {
        stbuf->st_mode = S_IFREG | 0644;
        stbuf->st_nlink = 1;
        stbuf->st_size = 0;
    }

    return res;
}


static
int admfs_getdir(const char *path, fuse_dirh_t h, fuse_dirfil_t filler)
{
    std::cerr<<"admfs_getdir:"<<path<<std::endl;

    dirent_vector items;
    conductor::instance().list(path,items);

    filler(h, ".", 0);
    filler(h, "..", 0);
    for (size_t i=0;i<items.size();++i)
    {
	std::cerr<<"adding item:"<<items[i]<<std::endl;
	filler(h,items[i].c_str(),0);
    }

    return 0;
}


static
int admfs_mkdir(const char *path, mode_t)
{
    //allow to create directories only on first level
    if (dir_level(path) != 2)
	return -EPERM;
    
    std::cerr<<"admfs_mkdir:"<<path<<std::endl;
    if (!(conductor::instance().add_plugin(path))) return -EPERM;

    return 0;	
}

static
int admfs_rmdir(const char *path)
{
    //allow to create directories only on first level
    if (dir_level(path) != 2)
	return -EPERM;

    std::cerr<<"admfs_rmdir:"<<path<<std::endl;

    conductor::instance().del_plugin(path);
    conductor::instance().destroy(path);
    
    return 0;
}


static
int admfs_unlink(const char *path)
{
    if (dir_level(path) != 3)
	return -EPERM;
    
    conductor::instance().destroy(path);

    return 0;
}


int admfs_open(const char *path, int mode)
{
    std::cerr<<"admfs_open:"<<path<<" mode:"<<std::oct<<mode<<std::endl;
    return (conductor::instance().open(path,mode))?0:-EPERM;
}


//dummy methods
static
int admfs_chmod(const char *, mode_t) { return 0; }
static
int admfs_chown(const char *, uid_t, gid_t) { return 0; }
static
int admfs_truncate(const char *, off_t) {return 0; }
static
int admfs_utime(const char *, struct utimbuf *) { return 0; }
static
int admfs_read(const char *path, char *buffer, size_t buflen, off_t off)
{
    return 0;
}
static
int admfs_write(const char *path, const char *buffer, size_t buflen, off_t off)
{
    return 0;
}


int main(int argc, char *argv[])
{

    fuse_operations admfs_operations;
    memset(&admfs_operations,0,sizeof(fuse_operations));
    
    admfs_operations.getattr = admfs_getattr;
    admfs_operations.getdir = admfs_getdir;
    admfs_operations.mkdir = admfs_mkdir;
    admfs_operations.rmdir = admfs_rmdir;
    admfs_operations.unlink = admfs_unlink;
    admfs_operations.open = admfs_open;
    admfs_operations.chmod = admfs_chmod;
    admfs_operations.chown = admfs_chown;
    admfs_operations.truncate = admfs_truncate;
    admfs_operations.utime = admfs_utime;
    
    fuse_main(argc, argv, &admfs_operations);


    return 0;
}

