//for DEBUG
#include <iostream>

#include <utils/pstream.hh>
#include <utils/line_iterator.hh>
#include <utils/str.hh>
#include <utils/os.hh>

#include <admfs/conductor.hh>
#include <admfs/support.hh>


const std::string plugin_dir="../samples/";

using namespace admfs;

namespace
{
    struct inserter
    {
	inserter(dirent_vector& vec): vec_(vec) {}
	void operator()(const supporter_map::value_type& item)
	{
	    vec_.push_back(item.first);
	}
	dirent_vector& vec_;
    };
    
    pid_t subprocess(const std::string& cmd,int &in,int& out,int& err)
    {
	in = out = err = -1;
	int stdin_fd = -1,stdout_fd = -1, stderr_fd = -1;
	pid_t pid;
	try
	{
	    alt::pipe(stdin_fd,in);
	    alt::pipe(out, stdout_fd);
	    alt::pipe(err, stderr_fd);
	    if(!(pid = alt::fork()))
	    {
		try
		{
		    ::close(in);
		    ::close(out);
		    ::close(err);
		    
		    ::close(STDIN_FILENO); alt::dup2(stdin_fd, STDIN_FILENO);
	    	    ::close(STDOUT_FILENO); alt::dup2(stdout_fd, STDOUT_FILENO);
		    ::close(STDERR_FILENO); alt::dup2(stderr_fd, STDERR_FILENO);
		    alt::exec(cmd);
	    	}
		catch(...)
		{
		}
		::exit(1);
	    }
	    ::close(stdin_fd);
	    ::close(stdout_fd);
	    ::close(stderr_fd);
	}
	catch(...)
	{
	    if (stdin_fd >= 0) ::close(stdin_fd);
	    if (stdout_fd >= 0) ::close(stdout_fd);
	    if (stderr_fd >= 0) ::close(stderr_fd);

	    if (in >= 0) ::close(in);
	    if (out >= 0) ::close(out);
	    if (err >= 0) ::close(err);
	}
	return pid;
    }
    
    /** split path to module and object names */
    void split(const std::string& path,std::string& module,std::string& object)
    {
        std::string::size_type pos1 = path.find_first_not_of("/");
	std::string::size_type pos2 = path.find("/",pos1);

	std::string::size_type pos3 = path.find_first_not_of("/",pos2);
	std::string::size_type pos4 = path.find("/",pos3);
    
    	module = path.substr(pos1,pos2-pos1);
	object = path.substr(pos3,(pos4 == std::string::npos)?pos4:pos4-pos3);
    }
}

/** @todo: add checking for object in appopriate supporter */
bool conductor_impl::exists(const std::string& path)
{
    std::cerr<<"conductor_impl::exists :"<<path<<std::endl;
    if (dir_level(path) == 2) //ask supporters list
	return supporters_.find(alt::trim(path," \t/")) != supporters_.end();

    return true;//return true for all other items
}


bool conductor_impl::add_plugin(const std::string& path)
{//simple check for existance of the plugin file in plugin dir
    std::cerr<<"conductor_impl::add_plugin\n";
    if (!access((plugin_dir+alt::trim_right(path," \t/")).c_str(),X_OK))
    {
	std::cerr<<"adding plugin\n";
	supporters_[alt::trim(path," \t/")]=runtime_info();
	return true;
    }
    return false;
}

void conductor_impl::del_plugin(const std::string& path)
{
    supporters_.erase(alt::trim(path," \t/"));
}

/** retrieve object information (if not write only), fill buffers with data */
bool conductor_impl::open(const std::string& path,int mode)
{
    std::string module,object;
    split(path,module,object);
    std::cerr<<"open module:"<<module<<" name:"<<object<<" mode:"<<mode<<std::endl;
    return false;
}

/**
 * 1. reparce path to determine supporter and it's object (READY)
 * 2. run subprocess with "-d name key" and read it's stderr (TODO)
 * 3. if stderr read result is not empty then create .stderr file (TODO)
 */
void conductor_impl::destroy(const std::string& path)
{
    std::cerr<<"conductor_impl::destroy"<<std::endl;

    std::string module,object;
    split(path,module,object);

    std::cerr<<"module:"<<module<<std::endl;
    std::cerr<<"object:"<<object<<std::endl;

    int in,out,err;
    pid_t pid = subprocess(plugin_dir+module+" -d "+object,in,out,err);

    std::vector<char> buff(BUFSIZ);
    int len;
    
    while ((len=::read(err,&buff[0],buff.size())) > 0)
	std::copy(buff.begin(),
	          buff.begin()+len,
		  std::back_inserter(supporters_[module].err_buffer_));

    alt::wait(pid);

//    supporters_[module].err_buffer_.push_back(0);
//    std::cerr<<"buffer content:"<<&supporters_[module].err_buffer_[0]<<std::endl;
}

void conductor_impl::list(const std::string& path,dirent_vector& dirlist)
{
    std::cerr<<"conductor_impl::list :"<<path<<std::endl;
    if ("/" == path)
    {
	std::cerr<<"root directory"<<std::endl;
	std::for_each(supporters_.begin(),
	              supporters_.end(),
		      inserter(dirlist));
    }
    else
    {//get info from appropriate plugin
	std::cerr<<"get information from plugin"<<std::endl;

	alt::ipstream is(plugin_dir+alt::trim_right(path," \t/")+" -l");
	std::string str;
	std::copy(alt::istream_line_iterator(is),
		  alt::istream_line_iterator(),
		  std::back_inserter(dirlist));
	//TODO: also add .error if we need it
    }
}
