#include <lowlevelio.hh>

class buffer
{
	descriptor fd_;
	bool eof_;
	std::string buf_;
	std::string::size_type pos_;

public:
	buffer(const descriptor& fd): fd_(fd), eof_(false), pos_(0) {}
	buffer(int fd): fd_(fd), eof_(false), pos_(0) {}

	char try_read_char(void);
	std::string try_read_until(char);
	void commit_read(void);
	void rollback_read(void);
	void put_back(void);
	void put_back(char c);

	bool eof(void) const { return eof_ && buf_.empty(); }

private:
	bool fill_buffer(void);
};

class obuffer
{
	descriptor fd_;
	std::string buf_;

public:
	obuffer(const descriptor& fd): fd_(fd) {}
	obuffer(int fd): fd_(fd) {}

	void put_char(char c);
	void put_string(const std::string&);

	void flush(void);

private:
	bool flush_buffer(void);
};
