#ifndef BUS_CONSOLE_HH
#define BUS_CONSOLE_HH

#include <string>
#include <iosfwd>
#include <bus/bus.hh>

struct console_error
{
	console_error(const std::string& why) : why_(why) {}
	const std::string& why(void) const { return why_; }
private:
	std::string why_;
};

struct request_console
{
	request_console(const std::string& why) : why_(why) {}
	const std::string& why(void) const { return why_; }
private:
	std::string why_;
};

void execute_command(std::istream&, std::ostream&, const std::string&);
bool console(std::istream& is, std::ostream& os);
void console_init(std::istream&, std::ostream&, int, char *[]);

bus_iterator find_point(const std::string&);
bus_iterator not_modules_end(const bus_iterator&);

void insert_cmd(std::istream&, std::ostream&, const std::string&);
void append_cmd(std::istream&, std::ostream&, const std::string&);
void remove_cmd(std::istream&, std::ostream&, const std::string&);
void list_cmd(std::istream&, std::ostream&, const std::string&);
void start_cmd(std::istream&, std::ostream&, const std::string&);
void stop_cmd(std::istream&, std::ostream&, const std::string&);
void status_cmd(std::istream&, std::ostream&, const std::string&);
void setstate_cmd(std::istream&, std::ostream&, const std::string&);
void setcurrent_cmd(std::istream&, std::ostream&, const std::string&);
void setneighbour_cmd(std::istream&, std::ostream&, const std::string&);
void load_cmd(std::istream&, std::ostream&, const std::string&);

#endif // BUS_CONSOLE_HH
