#ifndef BUS_PROTO_HH
#define BUS_PROTO_HH
#include <utils/err.hh>
#include <string>

namespace err
{
	struct proto: public general
	{
		proto(const std::string& why): general(why) {}
	};
};

void step(void);
void run(void);
std::string get_state(void);
void set_state(const std::string&);

namespace woobus { class module; }
woobus::module *current_module(void);
woobus::module *neigbour_module(void);
void set_current_module(woobus::module *);
void set_neighbour_module(woobus::module *);

#endif // BUS_PROTO_HH
