#ifndef COMMAND_SET_HH
#define COMMAND_SET_HH

#include <command.hh>

#include <list>
#include <vector>

class command_set
{
public:
	typedef std::list<command> commands_t;

private:
	std::vector<commands_t> commands_;

public:
	long
	add(const command&);
	
	long
	add(long, const command& );
	
	template <typename A> inline A for_each(long, A);
	template <typename A> inline A for_each(long, A) const;
};

template <typename A> A
command_set::for_each(long ndx, A a)
{
	return std::for_each(commands_[ndx].begin(), commands_[ndx].end(), a);
}

template <typename A> A
command_set::for_each(long ndx, A a) const
{
	return std::for_each(commands_[ndx].begin(), commands_[ndx].end(), a);
}

#endif // COMMAND_SET_HH
