#ifndef DIALOG_HH
#define DIALOG_HH

#include <context.hh>

#include <iosfwd>

class dialog
{
public:
	typedef std::map<char, std::string> actions_t;
	typedef std::map<std::string, long> buttons_t;

private:
	std::string screen_;
	actions_t actions_;
	buttons_t buttons_;
	context values_;
	char lastaction_;

public:
	dialog(void): lastaction_('a' - 1) {}

	void
	add_button(const std::string&, const std::string&, long);

	void
	add_label(const std::string&);

	void
	add_edit(const std::string&, const std::string&);

	void
	show(std::ostream&) const;

	long
	run(std::ostream&, std::istream&);
};

#endif // DIALOG_HH
