#include <stdexcept>
#include <list>

namespace err
{
	struct again: public std::runtime_error
	{
		again(const std::string& str): std::runtime_error(str) {}
	};

	struct eof
	{
	};

	struct sys: public std::runtime_error
	{
		sys(int e): std::runtime_error(strerror(e)) {}
	};
};

class descriptor
{
	int fd_;
public:
	descriptor(int fd): fd_(fd) {}

	fd_set *fdset(fd_set *) const;
	bool has_data(void) const;
	bool can_write(void) const;
	ssize_t read(char *, size_t) const;
	ssize_t write(const char *, size_t) const;
	int maxfd(int maxfd) const { return fd_ > maxfd ? fd_ : maxfd; }

	bool operator==(const descriptor& o) const { return fd_ == o.fd_; }
};

struct timeval;
bool select_read(const std::list<descriptor>&, struct timeval&);
