#ifndef MAPPER_HH
#define MAPPER_HH

#include <command.hh>

class mapper
{
	typedef std::map<std::string, command> map_t;
	map_t data_;

public:
	struct missing {};

	inline command
	operator[](const std::string&) const;

	inline mapper&
	operator()(const std::string&, const command&);

	inline command
	map(const std::string&) const;

	command&
	map(const std::string&, command&) const;

	mapper&
	add(const std::string&, const command&);

	mapper&
	remove(const std::string&);

	template <typename A> inline A for_each(A a);
	template <typename A> inline A for_each_pair(A a);
	template <typename A> inline A for_each_id(A a);
	template <typename A> inline A for_each_command(A a);
	template <typename A> inline A for_each(A a) const;
	template <typename A> inline A for_each_pair(A a) const;
	template <typename A> inline A for_each_id(A a) const;
	template <typename A> inline A for_each_command(A a) const;
};

inline mapper&
operator-(mapper& m, const std::string& viewid)
{
	return m.remove(viewid);
}

inline mapper&
mapper::operator()(const std::string& viewid, const command& cmd)
{
	return add(viewid, cmd);
}

inline command
mapper::operator[](const std::string& viewid) const
{
	return map(viewid);
}

inline command
mapper::map(const std::string& viewid) const
{
	command cmd;
	return map(viewid, cmd);
}

template <typename A> A mapper::for_each_pair(A a)
{
	return std::for_each(data_.begin(), data_.end(), a);
}

template <typename A> A mapper::for_each(A a)
{
	return for_each_pair(unpair<A>(a));
}

template <typename A> A mapper::for_each_id(A a)
{
	return for_each_pair(first<A>(a));
}

template <typename A> A mapper::for_each_command(A a)
{
	return for_each_pair(second<A>(a));
}

template <typename A> A mapper::for_each_pair(A a) const
{
	return std::for_each(data_.begin(), data_.end(), a);
}

template <typename A> A mapper::for_each(A a) const
{
	return for_each_pair(unpair<A>(a));
}

template <typename A> A mapper::for_each_id(A a) const
{
	return for_each_pair(first<A>(a));
}

template <typename A> A mapper::for_each_command(A a) const
{
	return for_each_pair(second<A>(a));
}

#endif // MAPPER_HH
