#ifndef MATCHER_HH
#define MATCHER_HH

#include <command.hh>

#include <vector>
#include <stdexcept>
#include <regex.h>

struct regex_error: public std::runtime_error
{
	regex_error(int, const regex_t&);
};

class matcher
{
	std::string name_re;
	std::vector<std::pair<std::string, std::string> > attr_re;

public:
	bool matches(const command& cmd, context& match) const;

	void clear(void);

	inline matcher&
	operator()(const std::string&);

	inline matcher&
	operator()(const std::string&, const std::string&);

	matcher&
	add(const std::string&);

	matcher&
	add(const std::string&, const std::string&);

	command
	as_command(void) const;
};

matcher&
matcher::operator()(const std::string& re)
{
	return add(re);
}

matcher&
matcher::operator()(const std::string& n_re, const std::string& v_re)
{
	return add(n_re, v_re);
}

#endif // MATCHER_HH
