#ifndef MODULE_HH
#define MODULE_HH
#include <utils/err.hh>
#include <iosfwd>

namespace err
{
	struct module: public general
	{
		module(const std::string& why): general(why) {}
	};

	struct not_running: public module
	{
		not_running(const std::string& why): module(why) {}
	};

	struct io: public module
	{
		io(const std::string& why): module(why) {}
	};
}

struct channel;

struct module
{
	module(const std::string& command);
	module(const std::string& name, const std::string& command);
	virtual ~module(void);

	bool is_running(void) const;
	void start(const std::string& = "");
	void stop(void);

	const std::string& name(void) const { return name_; }
	void name(const std::string& newname) { name_ = newname; }
	const std::string& command(void) const { return command_; }
	pid_t pid(void) const { return pid_; }

	std::istream& is(void);
	std::ostream& os(void);

private:
	void startup_io(void);
	void shutdown_io(void);

private:
	std::string name_;
	std::string command_;
	pid_t pid_;
	int in_, out_; // in == stdin of module, out == stdoout
	channel *io_;
};

#endif // MODULE_HH
