#ifndef PAIR_OPS_HH
#define PAIR_OPS_HH

template <typename A> struct unpair_i
{
	unpair_i(A a): a_(a) {}
	operator A() { return a_; }
	template <typename P> void operator()(P& p) { a_(p.first, p.second); }
private:
	A a_;
};

template <typename A> struct first_i
{
	first_i(A a): a_(a) {}
	operator A() { return a_; }
	template <typename P> void operator()(P& p) { a_(p.first); }
private:
	A a_;
};

template <typename A> struct second_i
{
	second_i(A a): a_(a) {}
	operator A() { return a_; }
	template <typename P> void operator()(P& p) { a_(p.second); }
private:
	A a_;
};

template <typename A> unpair_i<A> unpair(A a) { return unpair_i<A>(a); }
template <typename A> first_i<A> first(A a) { return first_i<A>(a); }
template <typename A> second_i<A> second(A a) { return second_i<A>(a); }

#endif // PAIR_OPS_HH
