#include <ext/stdio_filebuf.h>

namespace alt
{
	template <typename charT, typename Traits = std::char_traits<charT> >
		class basic_ifdstream;

	template <typename charT, typename Traits = std::char_traits<charT> >
		class basic_ofdstream;

	typedef basic_ifdstream<char>	ifdstream;
	typedef basic_ofdstream<char>	ofdstream;

	template <typename charT, typename Traits>
		class basic_ifdstream: public std::basic_istream<charT, Traits>
	{
	public:
		typedef charT					char_type;
		typedef Traits					traits_type;
		typedef typename traits_type::int_type		int_type;
		typedef typename traits_type::pos_type		pos_type;
		typedef typename traits_type::off_type		off_type;

		typedef __gnu_cxx::stdio_filebuf<char_type, traits_type>
					fdbuf_type;
		typedef std::basic_istream<char_type, traits_type> istream_type;

	private:
		fdbuf_type	fdbuf_;

	public:
		basic_ifdstream(int fd,
			std::ios_base::openmode mode = std::ios_base::in)
			: istream_type(NULL), fdbuf_(fd, mode, false, 1)
		{
			this->init(&fdbuf_);
		}
	};

	template <typename charT, typename Traits>
		class basic_ofdstream: public std::basic_ostream<charT, Traits>
	{
	public:
		typedef charT					char_type;
		typedef Traits					traits_type;
		typedef typename traits_type::int_type		int_type;
		typedef typename traits_type::pos_type		pos_type;
		typedef typename traits_type::off_type		off_type;

		typedef __gnu_cxx::stdio_filebuf<char_type, traits_type>
					fdbuf_type;
		typedef std::basic_ostream<char_type, traits_type> ostream_type;

	private:
		fdbuf_type	fdbuf_;

	public:
		basic_ofdstream(int fd,
			std::ios_base::openmode mode = std::ios_base::out)
			: ostream_type(NULL), fdbuf_(fd, mode, false, BUFSIZ)
		{
			this->init(&fdbuf_);
		}
	};
}
