#ifndef UTILS_STR_HH
#define UTILS_STR_HH
#include <string>
#include <iterator>

namespace alt
{
	bool char_before_is_esc(const std::string&, std::string::size_type);
	void remove_esc_before_char(std::string&, std::string::size_type);
	std::string split_on_unescaped_space(std::string&);

	struct args_iterator:
		public std::iterator<std::forward_iterator_tag, const char>
	{
		args_iterator(void) {}
		args_iterator(const std::string& str): str_(str)
		{
			arg_ = split_on_unescaped_space(str_);
		}

		args_iterator& operator ++(void)
		{
			arg_ = split_on_unescaped_space(str_);
			return *this;
		}

		args_iterator operator ++(int)
		{
			args_iterator tmp = *this;
			operator++();
			return tmp;
		}

		const char *operator *(void) const
		{
			return arg_.c_str();
		}

		bool operator == (const args_iterator& o) const
		{
			return str_ == o.str_ && arg_ == o.arg_;
		}

		bool operator != (const args_iterator& o) const
		{
			return !operator==(o);
		}

	private:
		std::string str_;
		std::string arg_;
	};

	std::string trim_left(const std::string&, const char * = " \t");
	std::string trim_right(const std::string&, const char * = " \t");
	std::string trim(const std::string&, const char * = " \t");
}

#endif // UTILS_STR_HH
