#include <bus/bus.hh>
#include <bus/console.hh>
#include <utils/os.hh>

void start_cmd(std::istream&, std::ostream&, const std::string& point)
{
	if(point.empty()) throw console_error("<point> is missing");

	bus_iterator i = not_modules_end(find_point(point));
	if(i->is_running())
		throw console_error("module is already running");
	try
	{
		i->start();
	}
	catch(const err::sys& x)
	{
		throw console_error(
			std::string("cannot start module: ") + x.why());
	}
}

void stop_cmd(std::istream&, std::ostream&, const std::string& point)
{
	if(point.empty()) throw console_error("<point> is missing");

	bus_iterator i = not_modules_end(find_point(point));
	if(!i->is_running())
		throw console_error("module is not running");
	try
	{
		i->stop();
	}
	catch(const err::sys& x)
	{
		throw console_error(
			std::string("cannot stop module: ") + x.why());
	}
}
