#include <bus/proto.hh>
#include <bus/console.hh>
#include <bus/bus.hh>

namespace
{
	static std::string mod(module *m)
	{
		if(!m) return "(-none-)";
		return m->name();
	}
}

void status_cmd(std::istream&, std::ostream& os, const std::string&)
{
	os	<< "current state:  " << get_state() << "\n"
		<< "current module: " << mod(current_module()) << "\n"
		<< "neigbour module: " << mod(neigbour_module()) << std::endl;
}

void setstate_cmd(std::istream& is, std::ostream& os, const std::string& state)
{
	set_state(state);
	status_cmd(is, os, "");
}

void setcurrent_cmd(std::istream& is, std::ostream& os,
						const std::string& point)
{
	if(point == "<none>") set_current_module(0);
	else set_current_module(&(*not_modules_end(find_point(point))));
	status_cmd(is, os, "");
}

void setneighbour_cmd(std::istream& is, std::ostream& os,
						const std::string& point)
{
	if(point == "<none>") set_neighbour_module(0);
	else set_neighbour_module(&(*not_modules_end(find_point(point))));
	status_cmd(is, os, "");
}
