#include <bus/core.hh>
#include <bus/ctrlc.hh>
#include <utils/os.hh>
#include <utils/fdstream.hh>

std::string woobus::module::read_line(void)
{
	if(!is_running()) start();
	if(ctrlc_pressed())
	{
		ctrlc_clear();
		throw err::ctrlc();
	}
	std::string buffer;
	getline(is(), buffer);
	if(ctrlc_pressed())
	{
		ctrlc_clear();
		is().clear();
		throw err::ctrlc();
	}
	return buffer;
}

void woobus::module::send_line(const std::string& msg)
{
	if(!is_running()) start();
	if(ctrlc_pressed())
	{
		ctrlc_clear();
		throw err::ctrlc();
	}
	os() << msg << std::endl;
	if(ctrlc_pressed())
	{
		ctrlc_clear();
		os().clear();
		throw err::ctrlc();
	}
}
