#include <csignal>

namespace
{
	static unsigned ctrlc_flag = 0;

	static void handler(int n)
	{
		ctrlc_flag++;
		if(!ctrlc_flag)		// overflow
			ctrlc_flag--;	// drop one, keep others
	}
};

bool ctrlc_pressed(void)
{
	return ctrlc_flag;
}

void ctrlc_clear(void)
{
	if(ctrlc_flag) --ctrlc_flag;
}

void ctrlc_init(void)
{
	struct sigaction act;
	act.sa_handler = handler;
	sigfillset(&act.sa_mask);
	sigaction(SIGINT, &act, 0);
}
