#include <bus/console.hh>
#include <bus/ctrlc.hh>
#include <bus/proto.hh>

#include <iostream>
#include <string>

int
main(int argc, char *argv[])
{
	ctrlc_init();
	console_init(std::cin, std::cout, argc, argv);

	while(console(std::cin, std::cout))
	{
		try
		{
			run();
		}
		catch(const err::proto& x)
		{
			std::cout << "error: " << x.why() << std::endl;
		}
		catch(const err::ctrlc&)
		{
			std::cout << "ctrl-c pressed" << std::endl;
		}
	}

	bus_finit();
	return 0;
}
