#include <iostream>
#include <command_io.hh>

template <typename S, typename K>
void split_discard_char(const std::string& str, S s, K k)
{
	std::string::size_type pos = str.find(s);
	if(pos != std::string::npos) k(str.substr(0, pos), str.substr(pos + 1));
	else k(str, "");
}

template <typename S, typename K>
void split_before_char(const std::string& str, S s, K k)
{
	std::string::size_type pos = str.find(s);
	if(pos != std::string::npos) k(str.substr(0, pos), str.substr(pos));
	else k(str, "");
}

template <typename S, typename K>
void split_after_char(const std::string& str, S s, K k)
{
	std::string::size_type pos = str.find(s);
	if(pos != std::string::npos) k(str.substr(0, pos), str.substr(pos));
	else k(str, "");
}

struct add_attr
{
	add_attr(command& cmd): cmd_(cmd) {}
	void operator ()(const std::string& first, const std::string& second)
	{
		cmd_(first, second);
	}
private:
	command& cmd_;
};

int usage(void)
{
	std::cerr << "usage: catcmd <name> [<name>=<value> ...]" << std::endl;
	return -1;
}

int main(int argc, char *argv[])
{
	argv++; argc--;
	if(!argc) return usage();
	command cmd(*argv++); argc--;
	while(argc--)
		split_discard_char(*argv++, '=', add_attr(cmd));
	std::cout << cmd;
	return 0;
}
