#include <chooser.hh>
#include <command_io.hh>
#include <istream>
#include <ostream>
#include <list>

#include <iostream>

struct same_module
{
	same_module(const module& m): m_(m) {}
	bool operator ()(const module& m) const
	{
		return m_.command() == m.command();
	}
private:
	const module& m_;
};

struct select_cmd
{
	select_cmd(const command& cmd, std::list<module>& handlers)
		: cmd_(cmd), handlers_(handlers) {}

	void operator()(const commander_t& cmd)
	{
		context dummy;
		if(cmd.first.matches(cmd_, dummy)
			&& std::find_if(handlers_.begin(), handlers_.end(),
				same_module(cmd.second)) == handlers_.end())
		{
			handlers_.push_back(cmd.second);
		}
	}

private:
	const command& cmd_;
	std::list<module>& handlers_;
};

void wait_accept(std::istream& is)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(is && buf == "vv") return;
		std::cerr
			<< "-- invalid accept line: \""
			<< buf << "\"" << std::endl;
	}
	std::cerr << "-- unexpected eof" << std::endl;
}

struct cmd_convert
{
	cmd_convert(const command& cmd, std::ostream& os): cmd_(cmd), os_(os) {}
	void operator()(module& m)
	{
		m.start("convert");
		m.os() << cmd_;

		command cmd;
		while(m.is() >> cmd) os_ << cmd;
		os_ << command("");
		m.stop();
	}
private:
	const command& cmd_;
	std::ostream& os_;
};

void convert(commanders_db& cmds, const command& cmd,
				std::istream& is, std::ostream& os)
{
	std::list<module> handlers;
	std::for_each(cmds.begin(), cmds.end(), select_cmd(cmd, handlers));
	if(handlers.empty())
	{
		os << "<<" << std::endl;
		wait_accept(is);
		os << command("/error/")("reason", "");
		os << "^^" << std::endl;
	}
	else
	{
		os << ">>" << std::endl;
		wait_accept(is);
		std::for_each(handlers.begin(), handlers.end(),
				cmd_convert(cmd, os));
		os << "^^" << std::endl;
	}
}

void convert_for_awhile(commanders_db& cmds,
				std::istream& is, std::ostream& os)
{
	while(is)
	{
		std::string buf;
		getline(is, buf);
		if(!is && buf.empty()) break;
		if(buf == ">>")
		{
			os << "vv" << std::endl;
			command cmd;
			is >> cmd;
			getline(is, buf);
			if(!is && buf.empty())
			{
				std::cerr << "unexpected eof" << std::endl;
				break;
			}
			if(buf != "^^")
			{
				std::cerr << "unexpected data" << std::endl;
				while(is)
				{
					getline(is, buf);
					if(is && buf == "^^") break;
				}
			}
			convert(cmds, cmd, is, os);
		}
		else if(buf == "<<")
		{
			os << "<>" << std::endl;
		}
		else
			std::cerr << "invalid address line" << std::endl;
	}
}
