#include <chooser.hh>
#include <command_io.hh>
#include <istream>

struct add_attr_to_matcher
{
	add_attr_to_matcher(matcher& label): label_(label) {}

	void operator()(const std::string& name, const std::string& value)
	{
		label_(name, value);
	}

private:
	matcher& label_;
};

void init(std::istream& cfg, commanders_db& cmds)
{
	while(cfg)
	{
		std::string cmd;
		getline(cfg, cmd);
		if(!cfg && cmd.empty()) break;
		module m(cmd);
		m.start("init");
		while(m.is())
		{
			command c;
			if(m.is() >> c)
			{
				matcher label;
				label(c.name());
				c.for_each(add_attr_to_matcher(label));
				cmds.push_back(make_pair(label, cmd));
			}
		}
		m.stop();
	}
}
