#include <chooser.hh>
#include <fstream>
#include <iostream>
#include <command_io.hh>

int
usage(void)
{
	std::cout << "usage: chooser <filename> <nextfds>" << std::endl;
	return 1;
}

struct dump_info
{
	void operator()(const matcher& label, const module& m)
	{
		std::cerr << "-------" << std::endl;
		std::cerr << label.as_command();
		std::cerr << "  --> " << m.command() << std::endl;
	}
};

void
dump_commanders(const commanders_db& commanders)
{
	std::for_each(commanders.begin(), commanders.end(),
			unpair(dump_info()));
}

int
main(int argc, char *argv[])
{
	if(argc < 2) return usage();

	commanders_db commanders;
	{
		std::ifstream is(argv[1]);
		init(is, commanders);
	}
	//dump_commanders(commanders);
	convert_for_awhile(commanders, std::cin, std::cout);
	return 0;
}
