#include <command_io.hh>

#include <iostream>

std::string
encode(std::string text) // string has been copied on purpose
{
	std::string::size_type pos = 0;
	while((pos = text.find_first_of(":$\n", pos)) != std::string::npos)
		switch(text[pos])
		{
			case ':' : text.replace(pos, 1, "$%"); pos += 2;break;
			case '$' : text.replace(pos, 1, "$$"); pos += 2;break;
			case '\n': text.replace(pos, 1, "$n"); pos += 2;break;
			default: break;
		}
	return text;
}

std::string
decode(std::string text) // string has been copied on purpose
{
	std::string::size_type pos = 0;
	while((pos = text.find('$', pos)) != std::string::npos
						&& pos != text.size() - 1)
		switch(text[pos + 1])
		{
			case '%': text.replace(pos, 2, ":"), ++pos; break;
			case '$': text.replace(pos, 2, "$"), ++pos; break;
			case 'n': text.replace(pos, 2, "\n"), ++pos; break;
			default: break;
		}
	return text;
}

struct out_pair
{
	out_pair(std::ostream& os): os_(os) {}
	void operator()(const std::string& key, const std::string& value)
	{
		os_ << '+' << encode(key) << ':' << encode(value) << '\n';
	}
private:
	std::ostream& os_;
};

std::ostream&
operator<<(std::ostream& os, const command& cmd)
{
	os << '%' << encode(cmd.name()) << '\n';
	cmd.for_each(out_pair(os));
	return os << '#' << std::endl;
}

static void
read_name(std::istream& is, command& cmd)
{
	std::string name;
	getline(is, name);
	cmd.name(decode(name));
}

static void
read_attr(std::istream& is, command& cmd)
{
	std::string buffer;
	getline(is, buffer);

	std::string::size_type pos = buffer.find(':');
	if(pos != std::string::npos)
		cmd.add(buffer.substr(0, pos), buffer.substr(pos + 1));
	else
		cmd.add(buffer, "");
}

static void
read_skip(std::istream& is)
{
	while(is && is.get()!='\n');
}


std::istream&
operator>>(std::istream& is, command& cmd)
{
	while(is)
		switch(is.get())
		{
			case '%': read_name(is, cmd); break;
			case '+': read_attr(is, cmd); break;
			case '#': read_skip(is); return is;
			default: 
			    if (!is.eof()) is.unget();
			    return is;
		}
	return is;
}
