#include <stdexcept>

#include <context.hh>

context&
context::add(const std::string& key, const std::string& value, policy_t policy)
{
	params_t::iterator i = params_.find(key);
	if(i != params_.end()) i->second = policy(i->second, value);
	else params_.insert(make_pair(key, value));
	return *this;
}

struct add_pair
{
	add_pair(context& c, context::policy_t p): ctx_(c), policy_(p) {}
	void operator()(const context::params_t::value_type& p) const
	{
		ctx_.add(p.first, p.second, policy_);
	}

private:
	context& ctx_;
	context::policy_t policy_;
};

context&
context::add(const context& ctx, policy_t policy)
{
	std::for_each(ctx.params_.begin(), ctx.params_.end(),
						add_pair(*this, policy));
	return *this;
}

const std::string&
context::get(const std::string& key) const
{
	params_t::const_iterator i = params_.find(key);
	if(i != params_.end()) return i->second;
	throw std::runtime_error("key not found");
}

bool
context::exists(const std::string& key) const
{
	return params_.find(key) != params_.end();
}

context&
context::remove(const std::string& key)
{
	return params_.erase(key), *this;
}

struct remove_pair
{
	remove_pair(context& c): ctx_(c) {}
	void operator()(const context::params_t::value_type& p) const
	{
		ctx_.remove(p.first);
	}

private:
	context& ctx_;
};

context&
context::remove(const context& ctx)
{
	std::for_each(ctx.params_.begin(), ctx.params_.end(),
						remove_pair(*this));
	return *this;
}
