#include <bufferio.hh>

bool buffer::fill_buffer(void)
{
	try
	{
		if(fd_.has_data())
		{
			char buf[8192];
			buf_.append(buf, fd_.read(buf, sizeof(buf)));
			return true;
		}
	}
	catch(const err::eof&)
	{
		eof_ = true;
	}
	return false;
}

char buffer::try_read_char(void)
{
	if(buf_.size() <= pos_) fill_buffer();
	if(buf_.size() > pos_) return buf_[pos_++];

	throw err::again("no characters available (yet)");
}

std::string buffer::try_read_until(char c)
{
	std::string::size_type pos = std::string::npos;
	if(buf_.size() > pos_) pos = buf_.find(c, pos_);
	if(pos == std::string::npos) fill_buffer();
	if(buf_.size() > pos_) pos = buf_.find(c, pos_);
	if(pos == std::string::npos) throw err::again("delimiter not found");
	std::string rv = buf_.substr(pos_, pos - pos_);
	pos_ = pos;
	return rv;
}

void buffer::commit_read(void)
{
	if(pos_ > 0)
	{
		buf_.erase(0, pos_);
		pos_ = 0;
	}
}

void buffer::rollback_read(void)
{
	pos_ = 0;
}

void buffer::put_back(void)
{
	if(pos_ > 0) pos_--;
}

void buffer::put_back(char c)
{
	if(pos_ > 0) buf_[--pos_] = c;
	else buf_.insert(0, 1, c);
}


bool obuffer::flush_buffer(void)
{
	if(fd_.can_write() && !buf_.empty())
	{
		buf_.erase(0, fd_.write(buf_.data(), buf_.size()));
		return true;
	}
	return false;
}

void obuffer::put_char(char c)
{
	buf_.append(1, c);
	if(buf_.size() >= 4096) flush_buffer();
}

void obuffer::put_string(const std::string& str)
{
	buf_.append(str);
	if(buf_.size() >= 4096) flush_buffer();
}

void obuffer::flush(void)
{
	flush_buffer();
}
