#include <typeio.hh>

char nistream::get_char(void)
{
	char rv;
	try
	{
		rv = buf_.try_read_char();
		buf_.commit_read();
	}
	catch(const err::again&)
	{
		buf_.rollback_read();
		throw;
	}
	return rv;
}

int nistream::get_int(void)
{
	int rv = 0;
	try
	{
		while(true)
		{
			char c = buf_.try_read_char();
			if(c >= '0' && c <= '9')
			{
				rv *= 10;
				rv += c;
			}
			else
			{
				buf_.put_back();
				break;
			}
		}
		buf_.commit_read();
	}
	catch(const err::again&)
	{
		buf_.rollback_read();
		throw;
	}
	return rv;
}

std::string nistream::get_string(char delim)
{
	std::string rv = buf_.try_read_until(delim);
	buf_.commit_read();
	return rv;
}

void nostream::put_char(char c)
{
	buf_.put_char(c);
}

void nostream::put_string(const std::string& str)
{
	buf_.put_string(str);
}

void nostream::flush(void)
{
	buf_.flush();
}
