#include <utils/str.hh>

bool alt::char_before_is_esc(const std::string& line,
					std::string::size_type pos)
{
	if(line.empty() || pos == 0 || pos > line.size()) return false;
	if(pos != std::string::npos) return line[pos - 1] == '\\';
	return *line.rbegin() == '\\';
}

void alt::remove_esc_before_char(std::string& line, std::string::size_type pos)
{
	if(line.empty() || pos < 1 || pos > line.size()) return;
	if(line[pos - 1] == '\\') line.erase(pos - 1, 1);
}

std::string alt::split_on_unescaped_space(std::string& line)
{
	if(line.empty()) return "";
	std::string::size_type pos = 0;
	while(true)
	{
		pos = line.find_first_of(" \t", pos);
		if(!char_before_is_esc(line, pos)) break;
		if(pos == std::string::npos) break;
		remove_esc_before_char(line, pos);
	}
	std::string::size_type pos2 = line.find_first_not_of(" \t", pos);
	std::string ans = line.substr(0, pos);
	line.erase(0, pos2);
	return ans;
}
