#include <utils/str.hh>

std::string alt::trim_left(const std::string& str, const char *lim)
{
	std::string::size_type pos = str.find_first_not_of(lim);
	return pos == std::string::npos ? "" : str.substr(pos);
}

std::string alt::trim_right(const std::string& str, const char *lim)
{
	std::string::size_type pos = str.find_last_not_of(lim);
	return pos == std::string::npos ? "" : str.substr(0, pos + 1);
}

std::string alt::trim(const std::string& str, const char *lim)
{
	return trim_right(trim_left(str, lim), lim);
}
