#include <eval.hh>

struct eval_and_append
{
	eval_and_append(const evaluator& eval, std::list<result>& lst)
		: eval_(eval), lst_(lst) {}
	void operator()(const result& r) { lst_.push_back(eval_(r)); }
private:
	const evaluator& eval_;
	std::list<result>& lst_;
};

func
evaluator::special(const std::string& name) const
{
	std::map<std::string, func>::const_iterator i;
	i = macrotab_.find(name);
	if(i == macrotab_.end())
		throw eval_error("eval: macro not found: " + name);
	return i->second;
}

func
evaluator::function(const std::string& name) const
{
	std::map<std::string, func>::const_iterator i;
	i = functab_.find(name);
	if(i == functab_.end())
		throw eval_error("eval: function not found: " + name);
	return i->second;
}

result
evaluator::operator()(const result& r) const
{
	if(r.is_eof() || r.is_string()) return r;
	if(r.lst_.empty()) throw eval_error("eval: cannot evaluate empty list");
	result first = *r.lst_.begin();
	if(first.is_string() && is_special(first.str_))
	{
		func f = special(first.str_);
		std::list<result> tmp(r.lst_);
		tmp.pop_front();
		return (*this)(f(tmp, *this));
	}
	else
	{
		std::list<result> tmp;
		std::for_each(r.lst_.begin(), r.lst_.end(),
				eval_and_append(*this, tmp));
		result first = *tmp.begin();
		if(!first.is_string())
			throw eval_error("eval: function name must be string");
		func f = function(first.str_);
		tmp.pop_front();
		return f(tmp, *this);
	}
}
