#include <eval.hh>

#include <list>

result
func_lookup(const std::list<result>& args, const evaluator& eval)
{
	if(args.size() < 2)
		throw eval_error("lookup: 2 args expected");

	std::list<result>::const_iterator i = args.begin();
	result ctxt = eval(*i++);
	if(!ctxt.is_string())
		throw eval_error("lookup: context must be string");

	result id = eval(*i);
	if(!id.is_string())
		throw eval_error("lookup: id must be string");

	std::map<std::string, context>::const_iterator v =
		eval.ctxttab_.find(ctxt.str_);

	if(v == eval.ctxttab_.end())
		throw eval_error("lookup: undefined context");

	return result(v->second(id.str_));
}
